/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 22/01/2023
 */

#include "../main.h"

SoftwareTag::SoftwareTag():xml::Tag()
{
}

       
SoftwareTag::~SoftwareTag()
{
}

void SoftwareTag::build()
{
    ProcessTag *ptag=(ProcessTag *) get_parent();
    vmp::str name=get_attr("name");
    ptag->process_->ptype_="software";
    try
    {
        ptag->process_->software_=vmp::env::vampiria_bin(name);
    }
    catch(vmp::exception &x)
    {
        parser_error("Software name '%s' Not Installed",name.c_str());
    }
    Tag *child=get_child(0);
    if(child != 0)
        ptag->process_->args_=vmp::unicode::shlex_split(child->get_text());
}

