#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date : 07/11/2024

import vmp
import vmp_net    as net
import vmp_event  as event
import vmp_plugin as plugin

def exit_(i):
  data=vmp.instance_.get_global()
  data.manager.stop()
  
def client_f(par,var):
  data=vmp.instance_.get_global()
  data.modname=par[0]
  data.plugname=par[1]
  data.rootpath=vmp.env.format_path(par[2])
  data.subject=par[3]
  if par[4] == 'yes':
    data.prompt=True
  else:
    data.prompt=False
  if(len(par) == 5) or par[5] == 'no':
    data.debug=False
  else:
    data.debug=True
  data.var=var
  vmp.debug("modname {0}".format(data.modname))
  vmp.debug("plugname {0}".format(data.plugname))
  vmp.debug("rootpath {0}".format(data.rootpath))
  vmp.debug("subject {0}".format(data.subject))
  vmp.debug("prompt {0}".format(data.prompt))
  vmp.debug("debug {0}".format(data.debug))
  if not vmp.fs.isdir(data.rootpath):
    vmp.fs.mkdir_wrap(data.rootpath,0o700)
  data.plogger=vmp.fs.union_path(data.rootpath,'proxy.log')
 
def proxy_f(par,var):
  data=vmp.instance_.get_global()
  if data.proxy == None: 
    data.logger=vmp.utils.Logger()
    if data.debug:
      data.logger.set(data.plogger,vmp.utils.LOG_DEBUG,False);
    else:
      data.logger.set(data.plogger,vmp.utils.LOG_INFO,False);
    data.proxy=net.ProxyChain(data.manager,data.logger)
  paddr=net.Address()
  paddr.set(par[1],par[2])
  if par[0] == "socks4":
    data.proxy.push_socks4(paddr)
  elif par[0] == "socks5":
    data.proxy.push_socks5(paddr)
  elif par[0] == "socks5auth":
    if len(par) == 5:
      data.proxy.push_socks5_userauth(paddr,par[3],par[4])
    else:
      vmp.except_s("Input 'proxy': type '{0}' must have 5 parameters".format(par[0]))

def inputcmd(cell,istr):
  data=vmp.instance_.get_global()
  data.plugin.command(istr)
   
def vmp_main():
  data=vmp.instance_.get_global()
  data.manager=event.Manager()
  data.proxy=None
  vmp.signal_wrap(['sigint','sigterm'],exit_)
  data.inputui=event.InputUI(data.manager)
  data.inputui.set_event(inputcmd,None)
  try:
    vmp.input_f('client',client_f)
    vmp.input_f('proxy',proxy_f)
    if data.proxy != None:
      vmp.debug("proxychain size={0} logpath='{1}'".format(data.proxy.size(),data.plogger)) 
    data.plugin=plugin.plugin_import(data.modname,data.plugname,"client.jrp",[data.manager,data.rootpath,data.subject,data.prompt,data.debug,data.proxy],data.var)
    data.inputui.input()
    data.manager.loop()
  except Exception as e:
    vmp.error(str(e))
    exit_(0)
  vmp.exit_ok()


    
  

