/* -*- Mode:Javascript; javscript-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.table lines associated with keys
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 27/05/2025
*/
/**A Component with a title and a body*/
class Mask_Section extends Vmp_Cmp_Div
{
  /**A constructor*/
  constructor()
  {
    super();
    let title=vmp_cmp_div();
    title.style.setProperty("background-color",vmp_rootvar("--background-color-window"));
    title.style.setProperty("border-radius","10px 10px 10px 10px");
    title.style.setProperty("text-align","center");
    this.register_cmp("title",title);
    this.appendChild(title);
  }
  /**
    *Init component
    *@param title {String} Section title
    *@param body {Tag} Body tag
    *@param width {String_css_width} width section
  */
  init(title,body,width)
  {
    this.search_cmp("title").innerHTML= `<h3>${title}</h3>`;
    this.style.setProperty("width",width);
    body.style.setProperty("width","100%");
    vmp_tag_childReplace(this,body,1);
  }
};
/**A Component the insertion of ipv4 masks*/
class Mask_Ipv4 extends Vmp_Cmp_Div
{
  /**A constructor*/
  constructor()
  {
    super();
    let ip0=vmp_cmp_input(2,"");
    this.register_cmp("ip0",ip0);
    let ip1=vmp_cmp_input(2,"");
    this.register_cmp("ip1",ip1);
    let ip2=vmp_cmp_input(2,"");
    this.register_cmp("ip2",ip2);
    let ip3=vmp_cmp_input(2,"");
    this.register_cmp("ip3",ip3);
    let p0=vmp_cmp_div();
    p0.style.setProperty("vertical-align","sub")
    p0.style.setProperty("padding-left","4px");
    p0.style.setProperty("padding-right","4px");
    p0.innerHTML=".";
    let p1=vmp_cmp_div();
    p1.style.setProperty("vertical-align","sub")
    p1.style.setProperty("padding-left","4px");
    p1.style.setProperty("padding-right","4px");
    p1.innerHTML=".";
    let p2=vmp_cmp_div();
    p2.style.setProperty("vertical-align","sub")
    p2.style.setProperty("padding-left","4px");
    p2.style.setProperty("padding-right","4px");
    p2.innerHTML=".";
    this.appendChild(mask_panel([ip0,p0,ip1,p1,ip2,p2,ip3]));
  }
  /**virtual function*/
  reset_impl(){this.set_value();}
  /**
    *Set ipv4 address
    *@param v {String} ipv4 address(if v == "" empty value) 
  */
  set_value(v="")
  {
    let ip0=this.search_cmp("ip0");
    let ip1=this.search_cmp("ip1");
    let ip2=this.search_cmp("ip2");
    let ip3=this.search_cmp("ip3");
    if((v == "") || !vmp_is_ipv4_raw(v))
    {
      ip0.set_value();
      ip1.set_value();
      ip2.set_value();
      ip3.set_value();
    }
    else
    {
      let split=vmp_unicode_str_split(ip,".");
      ip0.set_value(split[0]);
      ip1.set_value(split[1]);
      ip2.set_value(split[2]);
      ip3.set_value(split[3]);
    }
  }
  /**
    *Return input value
    *@return {String} ipv4 or undefined if the input values are not an ip address
  */
  get_value()
  {
    let ip0=this.search_cmp("ip0").get_value();
    let ip1=this.search_cmp("ip1").get_value();
    let ip2=this.search_cmp("ip2").get_value();
    let ip3=this.search_cmp("ip3").get_value();
    try
    {
      vmp_unicode_str_todigit_range(ip0,0,255);
      vmp_unicode_str_todigit_range(ip1,0,255);
      vmp_unicode_str_todigit_range(ip2,0,255);
      vmp_unicode_str_todigit_range(ip3,0,255);
      return `${ip0}.${ip1}.${ip2}.${ip3}`;
    }
    catch(error)
    {
    }
    return undefined;
  }
};

/**Channel onion status*/
const Mask_Onion_StatusCode={
  or_status_init:0,/*!<Channel or in initial state */
  or_status_channel:1,/*!<Channel or in creates channel*/
  or_status_channelrelay:2,/*!<Waiting for channel confirmation from relay*/
  or_status_channeltarget:3,/*!<Waiting for channel confirmation from target*/
  or_status_source:4,/*!<Channel or in source*/
  or_status_accept:5,/*!<Channel or in accept channel*/
  or_status_wait:6,/*!<Channel or in wait command*/
  or_status_relaychannel:7,/*!<Channel or in state creates a relay between peer */
  or_status_relay:8,/*!<Channel or in realy mode*/
  or_status_target:9,/*!<Channel or in target mode*/
  or_status_close:10,/*!<Channel or in close*/
  or_msg_status(status)
  {
    switch(code)
    {
      case this.or_status_init:return "Init";
      case this.or_status_channel:return "Channel handshake";
      case this.or_status_channelrelay:return "Channel relay confirm";
      case this.or_status_channeltarget:return "Channel target confirm";
      case this.or_status_source:return "Channel source";
      case this.or_status_accept:return "Accept handshake";
      case this.or_status_wait:return "Wait command";
      case this.or_status_relaychannel:return "Wait Relay channel";
      case this.or_status_relay:return "Relay channel";
      case this.or_status_target:return "Channel target";
      case this.or_status_close:return "Channel close";
    }
    return "";
  }
};
/**
  * Create a json data vmp_japi_type_jrp_misc("orchannelclose") used to close channel onion
  *<pre>
  *{ 
  *  jtype: vmp_japi_type_jrp_misc("orchannelclose"),
  *  jbody: 
  *  {
  *    cid:'channel id',
  *  }
  *}
  *</pre>
  *@param cid {Integer} connect id(read data jdata.get_integer_range("cid",1,Number.MAX))
  *@return {Vmp_JData} json data
*/
function mask_onion_japi_orchannelclose(cid)
{
    let ret=new Vmp_JData();
    ret.new_data(vmp_japi_type_jrp_misc("orchannelclose"));
    ret.set_integer_range("cid",1,Number.MAX,cid);
    return ret;
}

/**A Component for managing jrp::misc:onion*/
class Mask_Onion extends Vmp_Cmp_List
{
  /**A constructor*/
  constructor()
  {
    super();
    this.init({name:'Cid',width:'8%',order:true},{name:'Status',width:'26%',order:true},{name:'Permits',width:'8%',order:true},{name:'Nodes list: L=Local,S=Source,<BR>R=relay,T=target',width:'50%'},{name:'Close',width:'8%'})
  }
  status_update_impl(req,key,jdata)
  {
    if(jdata.jtype() == vmp_japi_type_jrp_misc("orchannelinfo")) 
    {
      try
      {
        let cid=jdata.get_integer_range("cid",1);
        let ccid;
        if (cid <=9)
          ccid=`  ${cid}`;
        else if (cid >= 100)
          ccid=`${cid}`;
        else
          ccid=` ${cid}`;
        let status=jdata.get_integer("status");
        let status_str=jdata.get_text("status_str");
        let permits=jdata.get_integer_range("permits",0);
        let jnodes=jdata.get_list("nodes",vmp_japi_type_jrp_misc("ornodeinfo"));
        let jnode,b,bid,address,subject,type,data,nodes=[];
        for(let i=0;i<jnodes.size();i++)
        {
          jnode=jnodes.get(i);
          address=jnode.get_text("address");
          subject=jnode.get_text("subject");
          type=jnode.get_text("type");
          if (subject == "")
            bid=`[${address},'']`;
          else
            bid=`[${address},${subject}]`;
          b=vmp_cmp_button(type,bid);
          b.addEventListener("click",this.nodeinfo.bind(this));
          b.style.setProperty("padding","5px");
          nodes.push(b);
        }
        if(status != Mask_Onion_StatusCode.or_status_close)
        {
          let close=vmp_cmp_button_img(Vmp_Img.close,"Close Channel",key);
          close.addEventListener("click",this.close.bind(this));
          data=[cid,status_str,permits,mask_panel(nodes),close];
        }
        else
          data=[cid,status_str,permits,mask_panel(nodes)];
        this.insert(key,data);
      }
      catch(error)
      {
        console.log(error);
      }  
      return true;
    }
    return false;
  }
  status_cancel_impl(req,key)
  {
    if(this.lines_.has(key))
    {
      this.cancel(key)
      return true;
    }
    return false;
  }
  req_close(req)
  {
    vmp_main_operwait_close(req);
  }
  /**Internal usage*/
  nodeinfo(event){vmp_wrap_alert(event.currentTarget.bid());}
  
  /**Internal usage*/
  close(event)
  {
    let key=event.currentTarget.bid();
    let line=this.lines_.get(key);
    if(line != undefined)
    {
      let cid=vmp_unicode_str_todigit(line.row.cells[0].innerHTML);
      let jdata=mask_onion_japi_orchannelclose(cid);
      vmp_main_operwait(this,jdata,"Onion close");
    }
  }
};

try
{
  vmp_wrap_define("mask-section",Mask_Section,'div');
  vmp_wrap_define("mask-ipv4",Mask_Ipv4,'div');
  vmp_wrap_define("mask-onion",Mask_Onion,'table');
}
catch(error)
{
  vmp_wrap_alert(error);
}
/**
  *Build a component section
  *@param title {String} Section title
  *@param body {Tag} Body tag
  *@param width {String_css_width} width section
  *@param {Mask_Section} component section
*/
function mask_section(title,body,width="98%")
{
  let ret=vmp_wrap_createElement("mask-section",'div');
  ret.init(title,body,width);
  return ret;
}
/**
  *Build a component ipv4
  *@return {Mask_Ipv4} component ipv4
*/
function mask_ipv4()
{
  let ret=vmp_wrap_createElement("mask-ipv4",'div');
  return ret;
}
/**
  *Build a component onion
  *@return {Mask_Onion} component onion
*/
function mask_onion()
{
  let ret=vmp_wrap_createElement("mask-onion",'table');
  return ret;
}

