/* -*- Mode:Javascript; javscript-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.table lines associated with keys
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 27/03/2025
*/
/**
  *Center and tag
  *@param {Tag} input tag
  *@return {Tag} Tag center
*/
function mask_tag_center(tag)
{
  let ret=vmp_wrap_createElement("center");
  ret.appendChild(tag);
  return ret;
}
/**
  *Inserts the horizontally aligned tag
  *@param {Tag} input tag
  *@return {Tag} Input tag  
*/
function mask_tag_horizontally(tag)
{
  tag.style.setProperty("display","inline-block");
  return tag;
}
/**
  *Component horizontally panel
  *@param cmps {Array_Cmp}
  *@return {Vmp_Cmp_Div} component horizontally panel
*/
function mask_panel(cmps=[])
{
  let ret=vmp_cmp_div();
  for(c of cmps)
    ret.appendChild(mask_tag_horizontally(c));
  return ret;
}
/**A variable data component*/
class Mask_Var extends Vmp_Cmp_Div
{
  /**A constructor*/
  constructor()
  {
    super();
    this.set_value();
  }
  /**
    *Set the value of the variable
    *@param value {String} of the variable
    *@param color {String_css_color} text color
  */
  set_value(text="-",color="black")
  {
    this.innerHTML=text;
    this.style.setProperty("color",color);
  }
  /**
    *Returns value var
    *return {String} value var
  */
  get_value(){return this.innerHTML;}
  /**virtual function*/
  reset_impl(){this.set_value("-");}
};
/**Create component text area*/
class Mask_TextArea extends vmp_component(HTMLTextAreaElement)
{
  /**A constructor*/
  constructor()
  {
    super();
    
  }
  /**
    *init text area
    *@param cols {Size) col area
    *@param rows {Size} row size
    *@param placeholder {String} containing a hint to the user of what can be entered in the control
  */
  init(cols,rows,placeholder="")
  {
    this.cols=cols;
    this.rows=rows;
    this.placeholder=placeholder;
  }
  /**
    *Setting textarea values
    *@param rows {String} string value
  */
  set_value(value=""){this.value=value;}
  /**
    *Return value setting
    *@return {String} value setting
  */
  get_value(){return this.value;}
  /**
    *Setting textarea values
    *@param rows {Array_String} rows values
  */
  set_value_rows(rows=[])
  {
    let v="";
    for(let i=0;i<rows.length;i++)
    {
      if(i == 0)
        v=vmp_unicode_str_format(rows[i]);
      else
        v=`${v}\n${vmp_unicode_str_format(rows[i])}`; 
    }
    this.set_value(v);  
  }
  /**
    *Return value setting as a rows vector
    *@return {Array_String} value setting
  */
  get_value_rows()
  {
    let values=vmp_unicode_str_split(this.get_value(),"\n");
    let ret=[];
    for (let v of values)
      ret.push(vmp_unicode_str_format(v));
    return ret;
  }
  /**virtual function*/
  enable_impl(){vmp_tag_enable(this);}
  /**virtual function*/
  disable_impl(){vmp_tag_disable(this);}
  /**virtual function*/
  reset_impl(){this.set_value();}
};
/**A variable data component*/
class Mask_Led extends Vmp_Cmp_Div
{
  /**A constructor*/
  constructor()
  {
    super();
    this.flash=0;
  }
  /**
    *Set led radius
    *@param radius {Size} led radius
  */
  set_radius(radius)
  {
    this.style.setProperty("border-radius","50%");
    this.style.setProperty("width",radius);
    this.style.setProperty("height",radius);
  }
  /**
    *Returns radius size
    *return {String} led radius
  */
  get_radius(){return this.style.getPropertyValue("width");}
  /**
    *Set the led color
    *@param color {String_css_color} led color
  */
  set_value(color="black"){this.style.setProperty("background-color",color);}
  /**
    *Returns led color
    *return {String} led color
  */
  get_value(){return this.style.getPropertyValue("background-color");}
  
  /**
    *set led flashing
    *@param time {Interval} blink interval,if equal to zero the led is solid
  */
  flashing(time=0)
  {
    if (this.flash != 0)
    {
      clearInterval(this.flash);
      this.flash=0;
    }
    if(time != 0)
    {
      this.flash=setInterval(function(){this.style.visibility=(this.style.visibility == 'hidden'?'':'hidden');},time);
    }
  }
};
try
{
  vmp_wrap_define("mask-var",Mask_Var,'div');
  vmp_wrap_define("mask-textarea",Mask_TextArea,"textarea");
  vmp_wrap_define("mask-led",Mask_Led,'div');
}
catch(error)
{
  vmp_wrap_alert(error);
}
/**
  *Build new component Var
  *@param value {String} of the variable
  *@param color {String_css_color} text color
  *@return {Mask_Var} component var
*/
function mask_var(text="-",color="black")
{
  let ret=vmp_wrap_createElement("mask-var","div");
  ret.set_value(text,color);
  return ret;
}
/**
  *Build new component TextArea
  *@param cols {Size) cols size
  *@param rows {Size} rows size
  *@param placeholder {String} containing a hint to the user of what can be entered in the control
  *@return {Mask_TextArea} component textarea
*/
function mask_textarea(cols,rows,placeholder="")
{
  let ret=vmp_wrap_createElement("mask-textarea","textarea");
  ret.init(cols,rows,placeholder);
  return ret;  
}
/**
  *Build new component led
  *@param radius {Size} led radius
  *@param color {String_css_color} led color
  *@param time {Interval} blink interval,if equal to zero the led is solid
  *@return {Mask_Led} component led
*/
function mask_led(radius,color="black",time=0)
{
  let ret=vmp_wrap_createElement("mask-led","div");
  ret.set_radius(radius);
  ret.set_value(color);
  ret.flashing(time);
  return ret;
}
