/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 11/08/2025
 */

#ifndef VAMPIRIA_XML_PARSER_H

#define VAMPIRIA_XML_PARSER_H 1

namespace vampiria { namespace xml {

//! Virtual class tag type utility
class TagType 
{ 
    public:
        //! A Constructor
        TagType(){}

        //! A Destructor
        virtual ~TagType(){};

        //!Virtual function create tag
        virtual xml::Tag *create_tag()=0;
};

//! Tag type implementation utility
template <typename T>
class TagType_impl : public TagType 
{
    public:
        //! A Constructor
        TagType_impl() {}
        
        //! A Destructor
        ~TagType_impl() {}
        
        typedef T type_;/*!<Tag type*/

        //!Create a new tag type_
        xml::Tag *create_tag()
        {
            return (Tag *) new type_();
        }
};

//! Real parser implemented
class Parser:public DomParser
{
    private:
        vmp::Table<vmp::str,xml::TagType *> typetag_;/*!<Table value (tagname,tagtype)*/

        //! Implemented virtual function(see xml::DomParser->create_tag())
        xml::Tag *create_tag(vmp::str name);

        //! Implemented virtual function(see xml::DomParser->destroy_impl())
        void destroy_impl();
        
    public:
        //! A Constructor
        Parser();

        //! A Destructor
        ~Parser();

        //! Add a type tag to the parser
        /*!
            @param name tag name
        */
        template<typename T>
        void add_tag(vmp::str name)
        {
            xml::TagType_impl<T> *ttype=new xml::TagType_impl<T>(); 
            try
            {
                typetag_.insert(name,(xml::TagType *)ttype);
            }
            catch(vmp::exception &x)
            {   
                vmp::except("xml::Parser::add_tag duplicate tag name %s",name.c_str());
            }
            
        }
};

}}

#endif

