/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 02/04/2025
 */

#include "vmp.h"

namespace vampiria { namespace vmp {

vmp_int atoi_wrap(vmp::str istr)
{
    return atoi(istr.c_str());   
}

vmp_real atof_wrap(vmp::str dstr)
{
    return atof(dstr.c_str());
}

vmp_int64 atoll_wrap(vmp::str dstr)
{
    vmp_assert(_ISOC99_SOURCE);
    return atoll(dstr.c_str());
}
void srand_wrap(vmp_uint seed)
{
    vmp_assert(_POSIX_C_SOURCE >= 199506L);
    srand(seed);    
}

vmp_uint rand_wrap(vmp_uint hop)
{
    vmp_assert(_POSIX_C_SOURCE >= 199506L);
    vmp_uint ret=rand();
    while(hop > 0)
    {
        ret=rand();
        hop--;
    }
    return ret;
}

vmp_bool istype_wrap(vmp_int c,vmp::str type)
{
    vmp_assert(_ISOC99_SOURCE || _POSIX_C_SOURCE >= 200112L);
    vmp_assert(_XOPEN_SOURCE || _DEFAULT_SOURCE);
    if((type == "alnum") && (isalnum(c) != 0))
        return true;
    if((type == "alpha") && (isalpha(c) != 0))
        return true;
    if((type == "ascii") && (isascii(c) != 0))
        return true;
    if((type == "blank") && (isblank(c) != 0))
        return true;
    if((type == "cntrl") && (iscntrl(c) != 0))
        return true;    
    if((type == "digit") && (c >= '0') && (c <= '9'))
        return true;    
    if((type == "graph") && (isgraph(c) != 0))
        return true;
    if((type == "lower") && (islower(c) != 0))
        return true;
    if((type == "print") && (isprint(c) != 0))
        return true;
    if((type == "punct") && (ispunct(c) != 0))
        return true;
    if((type == "space") && (isspace(c) != 0))
        return true;
    if((type == "upper") && (isupper(c) != 0))
        return true;
    if((type == "xdigit") && (((c >= '0') && (c <= '9')) || ((c >= 'a') && (c <= 'f')) || ((c >= 'A') && (c <= 'F'))))
        return true;
    return false;
}

vmp_char *strtok_r_wrap(vmp_char *str, const vmp_char *delim,vmp_char **saveptr)
{
    return strtok_r(str,delim,saveptr);
}

vmp_int strcmp_wrap(const vmp_char *s1,const vmp_char *s2)
{
    return strcmp(s1,s2);
}

vmp_int strncasecmp_wrap(const vmp_char *s1, const vmp_char *s2, vmp_size n)
{
    return strncasecmp(s1,s2,n);
}

vmp_char *strchr_wrap(const vmp_char *s,vmp_int c)
{
    return (vmp_char *)strchr(s,c);
}

vmp_char *strrchr_wrap(const vmp_char *s,vmp_int c)
{
    return (vmp_char *)strrchr(s,c);
}

}}

