/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 30/01/2025
 */

#include <stdlib.h>
#include <unistd.h>
#include <dirent.h>
#include <pty.h>
#include <fcntl.h>
#include <ctype.h>
#include <pwd.h>

#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/ioctl.h>
#include <sys/sysmacros.h>
#include <net/if.h>

#include "lib/types.h"
#include "lib/fd.h"
#include "lib/dev.h"
#include "lib/proc.h"
#include "lib/fs.h"

#ifndef VAMPIRIA_VMP_LIB_H

#define VAMPIRIA_VMP_LIB_H 1

namespace vampiria { namespace vmp {

//!For instance the global data of the module(Singleton)
class Instance
{
    private:        
        //! A constructor
        Instance();
        
        //! A destructor
        ~Instance();
        
        static void *global_;/*!< Global data*/
        static void *logger_;/*!<Logger for debugging library*/
    public:
        //! Get global data
        /*!
            @sa global_
            @return global data
        */        

        template<class DATA>        
        static DATA *get_global() 
        {
            return (DATA *) global_;
        } 

        //! Set global data
        /*!
            @param data set global data            
            @sa global_
            
        */
        template<class DATA>        
        static void set_global(DATA *data)
        {
            global_=(void *) data;
        }
        
        //! Get logger
        /*!
            @sa logger_
            @return logger data
        */        
        template<class DATA>        
        static DATA *get_logger() 
        {
            return (DATA *) logger_;
        } 

        //! Set logger
        /*!
            @param data set logger            
            @sa global_
            
        */
        template<class DATA>        
        static void set_logger(DATA *data)
        {
            logger_=(void *) data;
        }
};

}}

#endif

