/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 13/08/2024
 */

#ifndef VAMPIRIA_RAWNET_LIB_H

#define VAMPIRIA_RAWNET_LIB_H 1

namespace vampiria { namespace rawnet {

const vmp_int MTU_DEFAULT=65535;/*!<package mtu default*/

typedef pcap_t *rawnet_t;/*!<handle raw*/
typedef pcap_dumper_t *dumper_t;/*!<handle for dumper file*/

//!Callback type for loop_rawnet
/*!
    @param buf input buffer
    @param arg default arg
*/
typedef void (*RAWCBLOOP)(vmp::Buf *buf,void *arg);

//!empty function for loop_rawnet
void empty_rawloop(vmp::Buf *buf,void *arg);

//!Opens a handle of type linktype
/*!
    @param linktype pcap_datalink type
    @param snaplen length for the rawnet_t.
    @return handle raw
*/
rawnet::rawnet_t open_dead(vmp_int linktype,vmp_int snaplen);

//!Opens a handle for reading from a file
/*!
    @param file input file
    @return handle raw,if error throw exception
*/
rawnet::rawnet_t open_offline(vmp::str file);

//!Opens a handle for reading from an interface
/*!
    @param ifname interface name
    @return handle raw,if error throw exception
*/
rawnet::rawnet_t open_live(vmp::str ifname);

//!Wrapper pcap_datalink()
vmp_int datalink_rawnet(rawnet::rawnet_t raw);

//!Apply a filter to an input handle
/*!
    @param raw raw handler
    @param filter pcpa_filter
    @return if error throw exception
*/
void filter_rawnet(rawnet::rawnet_t raw,vmp::str filter);

//!Create a read loop from a raw handle
/*!
    @param raw raw input handler
    @param cb Callback call at each reading cycle
    @param arg arguments input used in callback
*/
void loop_rawnet(rawnet::rawnet_t raw,rawnet::RAWCBLOOP cb,void *arg);

//! Break a rawnet loop associated a raw input handle
/*!
    @param raw  
*/
void breakloop_rawnet(rawnet::rawnet_t raw);

//! Inject packet in rawnet raw input handler
/*!
    @param raw raw input handler
    @param buf packet input
    @return if error throw exception
*/
void inject_rawnet(rawnet::rawnet_t raw,vmp::Buf *buf);

//! Close raw handler
/*!
    @param praw pointer to raw handler
*/
void close_rawnet(rawnet::rawnet_t *praw);

//! Dumper open file
rawnet::dumper_t open_dumper(rawnet::rawnet_t handle,vmp::str wfile);

//! Dumper Write file
void write_dumper(rawnet::dumper_t dumper,vmp::Buf *buf);

//! Dumper close file
void close_dumper(rawnet::dumper_t *pdumber);

}}

#endif

