/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 30/05/2024
 */

#ifndef VAMPIRIA_PYLIB_ARG_FROM_PYTHON_H

#define VAMPIRIA_PYLIB_ARG_FROM_PYTHON_H 1

namespace vampiria { namespace pylib {

template<typename T>
struct get_instance_value
{
    static T value(void *inst)
    {
         T *tinst=(T*)inst;
         return (*tinst);
    }
};

template<typename T>
struct get_instance_value<T*>
{
    static T *value(void *inst)
    {
         return (T *)inst;
    }  
};

template<typename T>
T arg_from_python(pylib::Objref *obj)
{
    if(pylib::is_vector<T>::value_)
    {
        return pylib::is_vector<T>::arg_from_python(obj);
    }
    pylib::type_info t;
    void *inst;
    if (pylib::is_pointer<T>::value_)
        t = pylib::unwrap_type_id((T) 0);
    else
        t = pylib::unwrap_type_id((T*)0);
    inst=pylib::find_instance_impl(obj,t);
    if(inst != 0)
       return get_instance_value<T>::value(inst);
    vmp::except_s("arg_from_python invalid arguments type");
    return get_instance_value<T>::value(inst);
}

template<>
vmp_char arg_from_python<vmp_char>(pylib::Objref *obj);

template<>
vmp_uchar arg_from_python<vmp_uchar>(pylib::Objref *obj);

template<>
vmp_int16 arg_from_python<vmp_int16>(pylib::Objref *obj);

template<>
vmp_uint16 arg_from_python<vmp_uint16>(pylib::Objref *obj);

template<>
vmp_int arg_from_python<vmp_int>(pylib::Objref *obj);

template<>
vmp_uint arg_from_python<vmp_uint>(pylib::Objref *obj);

template<>
vmp_int64 arg_from_python<vmp_int64>(pylib::Objref *obj);

template<>
vmp_uint64 arg_from_python<vmp_uint64>(pylib::Objref *obj);

template<>
vmp_real arg_from_python<vmp_real>(pylib::Objref *obj);

template<>
vmp_bool arg_from_python<vmp_bool>(pylib::Objref *obj);

template<>
vmp::str arg_from_python<vmp::str>(pylib::Objref *obj);

template<>
pylib::Objref *arg_from_python<pylib::Objref *>(pylib::Objref *obj);

}}

#endif
