/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 22/01/2020
 */

#include "vmp.h"

#include "pylib/lib.h"
#include "pylib/args.h"
#include "pylib/stub.h"
#include "pylib/class.h"
#include "pylib/module.h"

#ifndef VAMPIRIA_PYLIB_H

#define VAMPIRIA_PYLIB_H 1

//! External function to be implemented with the code to initialize the module             
/*!
    @param init_module initial modules
*/
extern void vampiria_pylib_init_module(vampiria::pylib::Module init_module);

//! Macro Init root Module
/*!
     @param name root module name
*/
#define VAMPIRIA_PYLIB_INIT(name) \
    PyMODINIT_FUNC PyInit_ ## name (){\
        try{\
            vampiria::pylib::Module init_mod=vampiria::pylib::init_module(#name);\
	    if(PyErr_Occurred()) \
                return 0; \
            vampiria_pylib_init_module(init_mod);\
            return init_mod.ref();}\
        catch(vmp::exception &x) {\
            vmp::str error;\
            vmp::unicode::str_write(&error,"import module '%s' %s",#name,x.what());\
            PyErr_SetString(PyExc_RuntimeError,error.c_str());\
            return 0;}\
	return 0;}

#endif 

