/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 31/12/2024
 */

#include "process.h"

namespace vampiria { namespace process {

void exec(vmp::str filename,vmp::vector<vmp::str> args,vmp::args::Envp &env)
{
    vmp_size size=args.size();
    vmp_char *argp[size+2];
    argp[0]=(vmp_char *)filename.c_str();
    for(vmp_index i=0;i<size;i++)
        argp[i+1]=(vmp_char *)args[i].c_str();
    argp[size+1]=0;
    vmp::vector<vmp::str> venv=env.get_data();
    size=venv.size();
    vmp_char *envp[size+1];
    for(vmp_index i=0;i<size;i++)
        envp[i]=(vmp_char *)venv[i].c_str();
    envp[size]=0;
    try
    {
         vmp::execve_wrap(filename,argp,envp);
    }
    catch(vmp::exception &x)
    {    
         vmp::except("process::exec() '%s' error '%s'",filename.c_str(),x.what());
    }
}

PyInput::PyInput(vmp::vector<vmp::str> args,vmp::vector<vmp::str> vargs)
{
    args_=args;
    vargs_=vargs;
}
        
PyInput::~PyInput()
{
    args_.clear();
    vargs_.clear();
}

vmp::str PyInput::get_pytuple()
{
    vmp::str tuple;
    vmp::unicode::str_write(&tuple,"((");
    vmp_index i;
    for(i=0;i<args_.size();i++)
    {
        if(i != 0)
           vmp::unicode::str_cwrite(&tuple,",");
        vmp::unicode::str_cwrite(&tuple,"'%s'",args_[i].c_str());
    }
    if (i==1)
        vmp::unicode::str_cwrite(&tuple,",),(");
    else
        vmp::unicode::str_cwrite(&tuple,"),(");
    for(i=0;i<vargs_.size();i++)
    {
        if(i != 0)
           vmp::unicode::str_cwrite(&tuple,",");
        vmp::unicode::str_cwrite(&tuple,"'%s'",vargs_[i].c_str());
    }
    if(i==1)
        vmp::unicode::str_cwrite(&tuple,",))");
    else
        vmp::unicode::str_cwrite(&tuple,"))");
    return tuple;
}

Pyexec::Pyexec(vmp::str dirpath,vmp::str id,vmp_bool debug,vmp::args::Envp &envp)
{
    dirpath_=dirpath;
    id_=id;
    if(debug)
       debug_="True";
    else
       debug_="False";
    envp_=envp;
}

Pyexec::~Pyexec()
{
    dirpath_="";
    id_="";
    debug_="False";
    input_.clear();
}

void Pyexec::add_input(vmp::str name,vmp::vector<vmp::str> args,vmp::vector<vmp::str> vargs)
{
    input_.insert(name,PyInput(args,vargs));
}

vmp::str Pyexec::get_pydict()
{
    vmp::str dict;
    vmp::unicode::str_write(&dict,"{");
    vmp::vector<vmp::str> keys=input_.all_keys();
    for(vmp_index i=0;i<keys.size();i++)
    {
        if(i != 0)
            vmp::unicode::str_cwrite(&dict,",");
        vmp::unicode::str_cwrite(&dict,"'%s':[",keys[i].c_str());
        vmp::vector<process::PyInput> data=input_.search(keys[i]);
        vmp_index j;
        for(j=0;j<data.size();j++)
        {
            if(j != 0)
                vmp::unicode::str_cwrite(&dict,",");
            vmp::unicode::str_cwrite(&dict,"%s",data[j].get_pytuple().c_str());
        }
        if (j == 1)
            vmp::unicode::str_cwrite(&dict,",]");
        else
            vmp::unicode::str_cwrite(&dict,"]");
    }
    vmp::unicode::str_cwrite(&dict,"}");
    return dict;
}

void Pyexec::run()
{
    vmp::str cmd=vmp::env::python_exe();
    vmp::vector<vmp::str> args;
    args.push_back(vmp::env::python_main());
    args.push_back(dirpath_);
    args.push_back(id_);
    args.push_back(debug_);
    args.push_back(get_pydict()); 
    process::exec(cmd,args,envp_);
}

}}

