/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 25/03/2025
 */

#ifndef VAMPIRIA_PACKET_WEBSOCKET_H

#define VAMPIRIA_PACKET_WEBSOCKET_H 1

namespace vampiria { namespace packet { namespace websocket {

const vmp_uint WebSocketCode_Normal=1000;/*!<The connection close*/
const vmp_uint WebSocketCode_Shutdown=1001;/*!<Server is shutting down */
const vmp_uint WebSocketCode_Protocol= 1002;/*!<Some error in the protocol has happened */
const vmp_uint WebSocketCode_Type=1003;/*!<The type(text, binary) was not supported */
const vmp_uint WebSocketCode_Utf8 =1007;/*!<The message wasn't in UTF8 */
const vmp_uint WebSocketCode_Policy=1008;/*!<The policy of the server has been broken */
const vmp_uint WebSocketCode_Big=1009;/*!< The messages received is too big */
const vmp_uint WebSocketCode_Extension=1010;/*!< Mandatory extension missing */
const vmp_uint WebSocketCode_Unexpected=1011; /*!<Unexpected happened */

//!Returns the websocket code reason phrase.
/*!
    @param code websocket code
    @return reason phrase
*/
vmp::str WebSocketCode_reason(vmp_uint code);

//! Header websocket frame
class WebSocket_Framing_P:public packet::Packet
{
     private:
        //!Internal usage
        void set_payload_size();
     public:
        //! A constructor
        WebSocket_Framing_P();

        //! A destructor
        ~WebSocket_Framing_P();
        
        //! Reset packet
        void reset();
        
        //! Virtual function
        void read(vmp::Buf *buf);
        
        //! Virtual function
        void set(vmp::str field,vmp::str data);
        
        //! Set the payload from a byte vector
        /*!
            @param raw byte vector
            @param size vector size
        */
        void set_payload_raw(vmp_byte *raw,vmp_size size);
        
        //! Reads the buffer and returns a code with the read status
        /*!
            @param buf input buffer
            @param maxsize packet
            @return > 0(byte read) ok,-1 packet malformed,-2 the buffer is not complete,-3 packet too long data is missing
        */
        vmp_int ret_read(vmp::Buf *buf,vmp_size maxsize);
        
        //! Reads payload length
        /*!
            @return payload length
        */
        vmp_uint64 payload_len();
        
        //!Get payload
        /*!
            @param buf output buffer
        */
        void get_payload(vmp::Buf *buf);
        
        //!Write payload to input buffer
        /*!
            @param buf buffer to write payload
        */
        void add_payload(vmp::Buf *buf);
};

}}}

#endif

#include "websocket/ext.h"
#include "websocket/helper.h"
