/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 03/09/2024
 */

#ifndef VAMPIRIA_PACKET_NUMBER_H

#define VAMPIRIA_PACKET_NUMBER_H 1

namespace vampiria { namespace packet {

//! Datatype integer
class DataDigit:public packet::DataBytes
{
    protected:
        vmp_int data_;/*!<data*/
        vmp_int min_;/*!<min value accepted*/
        vmp_int max_;/*!<max value accepted*/
    public:
        //! A Constructor
        /*!
            @param field data field
            @param min min value accepted
            @param max max value accepted
        */
        DataDigit(vmp::str field,vmp_int min,vmp_int max);
        
        //! A Destructor
        ~DataDigit();
        
        //! Virtual function
        vmp::str get(vmp::str field);
        
        //! Virtual function
        void set(vmp::str field,vmp::str data);
        
        //! Virtual function
        void read(vmp::Buf *buf);
        
        //! Virtual function
        void write(vmp::Buf *buf);
        
        //! set data
        /*!
            @param data data value
            @return void or except in case of failure
        */
        void set_data(vmp_int data);
        
        //! Returns data value
        /*!
            @return data value
        */
        vmp_int get_data();
        
};

//! Datatype real
class DataReal:public packet::DataBytes
{
    protected:
        vmp_real data_;/*!<data*/
        vmp_real min_;/*!<min value accepted*/
        vmp_real max_;/*!<max value accepted*/
    public:
        //! A Constructor
        /*!
            @param field data field
            @param min min value accepted
            @param max max value accepted
        */
        DataReal(vmp::str field,vmp_real min,vmp_real max);
        
        ~DataReal();
        
        //! Virtual function
        vmp::str get(vmp::str field);
        
        //! Virtual function
        void set(vmp::str field,vmp::str data);
        
        //! Virtual function
        void read(vmp::Buf *buf);
        
        //! Virtual function
        void write(vmp::Buf *buf);
        
        //! set data
        /*!
            @param data data value
            @return void or except in case of failure
        */
        void set_data(vmp_real data);
        
        //! Returns data value
        /*!
            @return data value
        */
        vmp_real get_data();
};

}}

#endif

