/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 27/01/2024
*/
 
#include "net.h"

namespace vampiria { namespace net {

void connection_send_noimpl(event::Cell *cell,vmp::Buf *buf,net::Address *peer)
{
    vmp::str err;
    event::Manager *manager=cell->get_manager();
    net::EventConnection *conn=cell->event<net::EventConnection>();
    vmp::unicode::str_write(&err,"type=%s not send cb implemented",conn->evt_connection_strtype().c_str());
    manager->cell_close_err_spec(cell,"net::EventConnection",0,err.c_str());  
}

}}

