/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 29/15/2025
 */

#include "vmp.h"
#include "event.h"

#include <sys/socket.h>
#include <netdb.h>

#include "net/address.h"
#include "net/socket.h"

#ifndef VAMPIRIA_NET_H

#define VAMPIRIA_NET_H 1

namespace vampiria { namespace net {

//! Event recvfrom callback(see framework event)
/*!
    @param cell event cell
    @param buf recv data
    @param peer remote address peer
*/
typedef void (*EVTCBRECVFROM)(event::Cell *cell,vmp::Buf *buf,net::Address *peer);

//!Event accept callback (see framework event)
/*!
    @param cell listen event cell
    @param server accept connection event cell
*/
typedef void (*EVTCBACCEPT)(event::Cell *listen,event::Cell *server);

//! Function called by SOCKS servers in the initial phase for unauthenticated proxy connections
/*!
    @param cell event cell
    @return permissions assigned to anonymous connections
*/
typedef vmp_uint (*SOCKSCBNOAUTH)(event::Cell *cell);

//! Function called by SOCKS servers in the initial phase for user and password authentication
/*!
    @param cell event cell
    @param user user
    @param passwod password
    @return permissions assigned to connections
*/
typedef vmp_uint (*SOCKSCBUSERPASS)(event::Cell *cell,vmp::str user,vmp::str password);

//! Function empty_socksrequest_evction call to handle requests from a socks server
/*!
     @param cell event cell
     @param address target address
*/
typedef void (*SOCKSCBREQUEST)(event::Cell *cell,net::Address *address);

//! Empty callback for EVTCBRECVFROM
void empty_recvfrom_ev(event::Cell *cell,vmp::Buf *buf,net::Address *peer);

//! Empty callback for EVTCBACCEPT
void empty_accept_ev(event::Cell *listen,event::Cell *server);

//! Empty callback for SOCKSCBNOAUTH
vmp_uint empty_socksnoauth_ev(event::Cell *cell);

//! Empty callback for SOCKSCBUSERPASS
vmp_uint empty_socksuserpass_ev(event::Cell *cell,vmp::str user,vmp::str password);

//! Empty callback for SOCKSCBREQUEST
void empty_socksrequest_ev(event::Cell *cell,net::Address *address);

}}

#endif

#include "net/netdevice.h"
#include "net/connection.h"
#include "net/udp.h"
#include "net/tcp.h"
#include "net/socks.h"
#include "net/dns.h"

