/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 03/05/2025
*/

#ifndef VAMPIRIA_JSON_JLIST_H

#define VAMPIRIA_JSON_JLIST_H 1

namespace vampiria { namespace json {

//! JList Class
/*!
     Used to work with JData lists
*/
class JList
{
     private:
         json::JsonObj *list_;/*!<json list object references*/
         vmp::str jtype_;/*!<JData type (jtype_="" generic list not typed)*/
         friend json::JData;/*!<internal usage*/
         
         //! Internal usage
         void check_init(vmp::str fname);
         
         //! Internal usage
         void set(json::JsonObj *list,vmp::str jtype);
     public:

         //! A constructor
         JList();

         //! A destructor
         ~JList();

         //! Return the list json data object
         /*!
            @ref list_
            @return json object list or except in case of failure
         */
         json::JsonObj *list();

         //! Return json data types in the list
         /*!
             @ref jtype_
             @return json data types or except in case of failure
         */       
         vmp::str jdata_type();

         //! Reset json data list
         /*!
             @ref list_
         */
         void reset();

         //! Insert a JData at the end of the list
         /*!
             @param jdata jdata to insert
             @return void or except in case of failure
         */
         void push(json::JsonObj *jdata);

         //! Replaces the jdata of index i
         /*!
             @param i index to data replace
             @param jdata new data replace
             @return void or except in case of failure
         */
         void replace(vmp_index i,json::JsonObj *jdata);
         
         //! Gets a copy jdata of index i
         /*!
             @param i index to data replace
             @param jdata gets jdata
             @return void or except in case of failure
         */
         void get(vmp_index i,json::JsonObj *jdata);
         
         //! Returns the size of the list
         /*!
             @return the size list or except in case of failure
         */
         vmp_size size();
};

}}

#endif

