/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 20/03/2025
*/

#ifndef VAMPIRIA_JSON_JAPI_OPER_H

#define VAMPIRIA_JSON_JAPI_OPER_H 1

namespace vampiria { namespace json {

//! Create a json data json::japi("oper") used for request operations between threads
/*!
    <pre>
    { 
       jtype: json::japi("oper"),
       jbody: 
       {
           id:'id',
           oper:'oper',
           bin:'binary data',
           input:{json data object}
       }
    }
    </pre>
    @param obj object where the json data is inserted
    @param id identity comunication (read data json::jdata.get_text("id"))
    @param input json data input of the operation (read data json::jdata.get_subtype("input"))
    @param bin binary data(read jdata.get_text("bin"))
    @return void or except in case of failure
*/
void japi_oper(json::JsonObj *obj,vmp::str id,json::JsonObj *input,vmp::Buf *bin=0);

//! Create a json data json::japi("operkill") used request to terminate an operation
/*!
    <pre>
    { 
       jtype: json::japi("operkill"),
       jbody: 
       {
           id:'id',
       }
    }
    </pre>
    @param obj object where the json data is inserted
    @param id identity comunication(equal to that of the request)(read data json::jdata.get_text("id"))
    @return void or except in case of failurevoid japi_login(json::JsonObj *obj,vmp::str user,vmp::str password,vmp_bool md5_password)
*/
void japi_oper_kill(json::JsonObj *obj,vmp::str id);

//! Create a json data json::japi("operdata") used for response an operations request
/*!
    <pre>
    { 
       jtype: json::japi("operdata"),
       jbody: 
       {
           id:'id',
           bin:'binary data',
           data:{json data object}
       }
    }
    </pre>
    @param obj object where the json data is inserted
    @param id identity comunication(equal to that of the request)(read data json::jdata.get_text("id"))
    @param data json data output response(read data json::jdata.get_subtype("data"))
    @param bin binary data(read jdata.get_text("bin"))
    @return void or except in case of failure
*/
void japi_oper_data(json::JsonObj *obj,vmp::str id,json::JsonObj *data,vmp::Buf *bin=0);

//! Create a json data json::japi("operpush") used to send data related to the request from the person who created the request
/*!
    <pre>
    { 
       jtype: json::japi("operpush"),
       jbody: 
       {
           id:'id',
           bin:'binary data'
           data:{json data object}
       }
    }
    </pre>
    @param obj object where the json data is inserted
    @param id identity comunication(equal to that of the request)(read data json::jdata.get_text("id"))
    @param data json data pushed(read data json::jdata.get_subtype("data"))
    @param bin binary data(read jdata.get_text("bin"))
    @return void or except in case of failure
*/
void japi_oper_push(json::JsonObj *obj,vmp::str id,json::JsonObj *data,vmp::Buf *bin=0);

//! Create a json data json::japi("operclose") used to close an operations request
/*!
    <pre>
    { 
       jtype: json::japi("operclose"),
       jbody: 
       {
           id:'id',
           code:'code',
           msg:'msg'
       }
    }
    </pre>
    @param obj object where the json data is inserted
    @param id identity comunication(equal to that of the request)(read data json::jdata.get_text("id"))
    @param code operation exit code (read data json::jdata.get_integer("code"))
    @param msg  operation exit message (read data json::jdata.get_text("msg"))
    @return void or except in case of failure
*/
void japi_oper_close(json::JsonObj *obj,vmp::str id,vmp_int code,vmp::str msg);

}}

#endif

