/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 20/03/2025
*/

#include "json.h"

namespace vampiria { namespace json {

void japi_oper(json::JsonObj *obj,vmp::str id,json::JsonObj *input,vmp::Buf *bin)
{
    vmp::except_check_pointer((void *) obj,"json::japi_oper(obj=Null)");
    json::JData jdata,tmp;
    try
    {
        tmp.set(input);
    }
    catch(vmp::exception &x)
    {
        vmp::except_s("json::japi_oper(input='bad object')");
    }
    jdata.new_data(obj,json::japi("oper"));
    jdata.set_text("id",id);
    if(bin == 0)
        jdata.set_text("bin","");
    else
    {
        bin->index();
        jdata.set_text("bin",bin->read_xstr(bin->size()));
    }
    jdata.set_subtype("input",input);    

}

void japi_oper_kill(json::JsonObj *obj,vmp::str id)
{
    vmp::except_check_pointer((void *) obj,"json::japi_oper_kill(obj=Null)");
    json::JData jdata;
    jdata.new_data(obj,json::japi("operkill"));
    jdata.set_text("id",id);
}

void japi_oper_data(json::JsonObj *obj,vmp::str id,json::JsonObj *data,vmp::Buf *bin)
{
    vmp::except_check_pointer((void *) obj,"json::japi_oper_data(obj=Null)");
    json::JData jdata,tmp;
    try
    {
        tmp.set(data);
    }
    catch(vmp::exception &x)
    {
        vmp::except_s("json::japi_oper_data(data='bad object')");
    }
    jdata.new_data(obj,json::japi("operdata"));
    jdata.set_text("id",id);
    if(bin == 0)
        jdata.set_text("bin","");
    else
    {
        bin->index();
        jdata.set_text("bin",bin->read_xstr(bin->size()));
    }
    jdata.set_subtype("data",data);
}

void japi_oper_push(json::JsonObj *obj,vmp::str id,json::JsonObj *data,vmp::Buf *bin)
{
    vmp::except_check_pointer((void *) obj,"json::japi_oper_push(obj=Null)");
    json::JData jdata,tmp;
    try
    {
        tmp.set(data);
    }
    catch(vmp::exception &x)
    {
        vmp::except_s("json::japi_oper_push(data='bad object')");
    }
    jdata.new_data(obj,json::japi("operpush"));
    jdata.set_text("id",id);
    if(bin == 0)
        jdata.set_text("bin","");
    else
    {
        bin->index();
        jdata.set_text("bin",bin->read_xstr(bin->size()));
    }
    jdata.set_subtype("data",data);
}

void japi_oper_close(json::JsonObj *obj,vmp::str id,vmp_int code,vmp::str msg)
{
    vmp::except_check_pointer((void *) obj,"json::japi_oper_close(obj=Null)");
    json::JData jdata;
    jdata.new_data(obj,json::japi("operclose"));
    jdata.set_text("id",id);
    jdata.set_integer("code",code);
    jdata.set_text("msg",msg);    
}

}}

