/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 09/05/2025
*/

#ifndef VAMPIRIA_JRP_MISC_ONION_JAPI_H

#define VAMPIRIA_JRP_MISC_ONION_JAPI_H 1

namespace vampiria { namespace jrp { namespace misc {

//! Create a json data jrp::misc::japi("orchannel") used for or channel message
/*!
    <pre>
    { 
       jtype: json::japi("orchannel"),
       jbody: 
       {
       }
    }
    </pre>
    @param obj object where the json data is inserted
    @return void or except in case of failure
*/
void japi_orchannel(json::JsonObj *obj);

//! Create a json data jrp::misc::japi("orreply") used for or reply message
/*!
    <pre>
    { 
       jtype: json::japi("orreply"),
       jbody: 
       {
           cmd:'command to replicate',
           status: jrp status reply,
           msg:'status reply in string format'
       }
    }
    </pre>
    @param obj object where the json data is inserted
    @param cmd command to replicate (read data json::jdata.get_text("cmd"))
    @param status command to replicate (read data json::jdata.get_integer("status"))
    @param msg status reply in string format (read data json::jdata.get_text("msg"))
    @return void or except in case of failure
*/
void japi_orreply(json::JsonObj *obj,vmp::str cmd,vmp_int status,vmp::str msg);

//! Create a json data jrp::misc::japi("orrelay") used for or reply message
/*!
    <pre>
    { 
       jtype: json::japi("orrelay"),
       jbody: 
       {
           target:'relay target node'
       }
    }
    </pre>
    @param obj object where the json data is inserted
    @param target realy target node (read data json::jdata.get_text("target"))
    @return void or except in case of failure
*/
void japi_orrelay(json::JsonObj *obj,vmp::str target);

//! Create a json data jrp::misc::japi("ortarget") used for or channel message
/*!
    <pre>
    { 
       jtype: json::japi("ortarget"),
       jbody: 
       {
       }
    }
    </pre>
    @param obj object where the json data is inserted
    @return void or except in case of failure
*/
void japi_ortarget(json::JsonObj *obj);

//! Create a json data jrp::misc::japi("ordata") used for or channel message
/*!
    <pre>
    { 
       jtype: json::japi("ordata"),
       jbody: 
       {
       }
    }
    </pre>
    @param obj object where the json data is inserted
    @return void or except in case of failure
*/
void japi_ordata(json::JsonObj *obj);

//! Create a json data jrp::misc::japi("orchannelclose") used to close a channel
/*!
    <pre>
    { 
       jtype: json::japi("orchannelclose"),
       jbody: 
       {
           cid:channel id,
       }
    }
    </pre>
    @param obj object where the json data is inserted
    @param cid channel id(read data json::jdata.get_integer_range("cid",1,vmp::INTMAX))
    @return void or except in case of failure
*/
void japi_orchannelclose(json::JsonObj *obj,vmp_index cid);

//! Create a json data jrp::misc::japi("orping") used for ping message
/*!
    <pre>
    { 
       jtype: json::japi("orping"),
       jbody: 
       {
       }
    }
    </pre>
    @return void or except in case of failure
*/
void japi_orping(json::JsonObj *obj);

}}}

#endif

