/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 09/05/2025
*/

#include "jrp.h"

namespace vampiria { namespace jrp { namespace misc {

void japi_orchannel(json::JsonObj *obj)
{
    json::JData jdata;
    vmp::except_check_pointer((void *) obj,"jrp::misc::japi_orchannel(obj=Null)");
    jdata.new_data(obj,jrp::misc::japi("orchannel"));
}

void japi_orreply(json::JsonObj *obj,vmp::str cmd,vmp_int status,vmp::str msg)
{
    json::JData jdata;
    vmp::except_check_pointer((void *) obj,"jrp::misc::japi_orreply(obj=Null)");
    jdata.new_data(obj,jrp::misc::japi("orreply"));
    jdata.set_text("cmd",cmd);
    jdata.set_integer("status",status);
    jdata.set_text("msg",msg);
}

void japi_orrelay(json::JsonObj *obj,vmp::str target)
{
    json::JData jdata;
    vmp::except_check_pointer((void *) obj,"jrp::misc::japi_orrelay(obj=Null)");
    jdata.new_data(obj,jrp::misc::japi("orrelay"));
    jdata.set_text("target",target); 
}

void japi_ortarget(json::JsonObj *obj)
{
    json::JData jdata;
    vmp::except_check_pointer((void *) obj,"jrp::misc::japi_ortarget(obj=Null)");
    jdata.new_data(obj,jrp::misc::japi("ortarget"));
}

void japi_ordata(json::JsonObj *obj)
{
    json::JData jdata;
    vmp::except_check_pointer((void *) obj,"jrp::misc::japi_ordata(obj=Null)");
    jdata.new_data(obj,jrp::misc::japi("ordata"));
}

void japi_orchannelclose(json::JsonObj *obj,vmp_index cid)
{
    json::JData jdata;
    vmp::except_check_pointer((void *) obj,"jrp::misc::japi_orchannelclose(obj=Null)");
    jdata.new_data(obj,jrp::misc::japi("orchannelclose"));
    jdata.set_integer_range("cid",1,vmp::INTMAX,cid);   
}

void japi_orping(json::JsonObj *obj)
{
    json::JData jdata;
    vmp::except_check_pointer((void *) obj,"jrp::misc::japi_orchannelclose(obj=Null)");
    jdata.new_data(obj,jrp::misc::japi("orping"));
}

}}}

