/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 09/05/2025
*/

#ifndef VAMPIRIA_JRP_MISC_ONION_CB_H

#define VAMPIRIA_JRP_MISC_ONION_CB_H 1

namespace vampiria { namespace jrp { namespace misc {

class Onion;

//! Simplex onion callback
/*!
    @param onion onion object
    @param cid channel id
*/
typedef void (*ONIONCB)(jrp::misc::Onion *onion,vmp_index cid);

//! Verify onion callback
/*!
    @param onion onion object
    @param cid channel id
    @return true if the operation is allowed,otherwise false
*/
typedef vmp_bool (*ONIONVRFYCB)(jrp::misc::Onion *onion,vmp_index cid);

//! Accept onion callback
/*!
    @param onion onion object
    @param cid channel id
    @param peer peer fingerprint
    @return user permissions or 0 in case of denied access
*/
typedef vmp_uint (*ONIONACCEPTCB)(jrp::misc::Onion *onion,vmp_index cid,vmp::str peer);

//! Recv onion callback
/*!
    @param onion onion object
    @param cid channel id
    @param jdata json data recv
    @param payload buffer payload recv
*/
typedef void (*ONIONRECVCB)(jrp::misc::Onion *onion,vmp_index cid,json::JsonObj *jdata,vmp::Buf *payload);

//! Close onion callback
/*!
    @param onion onion object
    @param cid channel id
    @param status close status
    @param msg close message
*/
typedef void (*ONIONCLOSECB)(jrp::misc::Onion *onion,vmp_index cid,vmp_int status,vmp::str msg);

//! Error onion callback
/*!
    @param onion onion object
    @param cid channel id
    @param peer that generated the error
    @param status close status
    @param msg close message
*/
typedef void (*ONIONERRCB)(jrp::misc::Onion *onion,vmp_index cid,vmp::str peer,vmp_int status,vmp::str msg);

//!Empty ONIONCB callback
void empty_onioncb(jrp::misc::Onion *onion,vmp_index cid);

//!Empty ONIONVRFYCB callback
vmp_bool empty_onionvrfycb(jrp::misc::Onion *onion,vmp_index cid);

//!Empty ONIONACCEPTCB callback
vmp_uint empty_onionacceptcb(jrp::misc::Onion *onion,vmp_index cid,vmp::str peer);

//!Empty ONIONRECVCB callback
void empty_onionrecvcb(jrp::misc::Onion *onion,vmp_index cid,json::JsonObj *jdata,vmp::Buf *payload);

//!Empty ONIONCLOSECB callback
void empty_onionclosecb(jrp::misc::Onion *onion,vmp_index cid,vmp_int status,vmp::str msg);

//!Empty ONIONERRCB callback
void empty_onionerrcb(jrp::misc::Onion *onion,vmp_index cid,vmp::str peer,vmp_int status,vmp::str msg);

}}}

#endif

