/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 20/07/2025
*/

#include "jrp.h"

namespace vampiria { namespace jrp { namespace misc {

void empty_onioncb(jrp::misc::Onion *onion,vmp_index cid)
{
}

vmp_bool empty_onionvrfycb(jrp::misc::Onion *onion,vmp_index cid)
{
    return true;
}

vmp_uint empty_onionacceptcb(jrp::misc::Onion *onion,vmp_index cid,vmp::str peer)
{
    return 0;
}

void empty_onionrecvcb(jrp::misc::Onion *onion,vmp_index cid,json::JsonObj *jdata,vmp::Buf *payload)
{
}

void empty_onionclosecb(jrp::misc::Onion *onion,vmp_index cid,vmp_int status,vmp::str msg)
{
}

void empty_onionerrcb(jrp::misc::Onion *onion,vmp_index cid,vmp::str peer,vmp_int status,vmp::str msg)
{
}

void Onion::connect_ok(jrp::misc::OrChannel *channel)
{
    vmp_index cid=channel->cid_;
    channel_status_internal(channel,jrp::misc::or_status_source);
    active_ping(channel);
    mutex_.unlock();
    try
    {
        connect_(this,cid);
    }
    catch(vmp::exception &x)
    {
        vmp::error("jrp::misc::Onion::connect_ok()[connect_] %s",x.what());  
    }
    mutex_.lock();
}

void Onion::connect_err(jrp::misc::OrChannel *channel,vmp::str peer,vmp_int status,vmp::str msg)
{
    vmp_index cid=channel->cid_;
    channel_status_internal(channel,jrp::misc::or_status_close);
    if(msg == "")
        msg=jrp::msg_status(status);
    mutex_.unlock();
    try
    {
        connecterr_(this,cid,peer,status,msg);
    }
    catch(vmp::exception &x)
    {
        vmp::error("jrp::misc::Onion::connect_err()[connecterr_] %s",x.what());  
    }
    mutex_.lock();
    if(!close_channel_source(channel))
        free_channel(channel);
}

void Onion::source_recv(jrp::misc::OrChannel *channel,json::JsonObj *jdata,vmp::Buf *payload)
{
    vmp_index cid=channel->cid_;
    mutex_.unlock();
    try
    {
        recvsource_(this,cid,jdata,payload);
    }
    catch(vmp::exception &x)
    {
        vmp::error("jrp::misc::Onion::source_recv()[recvsource_] %s",x.what());  
    }
    mutex_.lock();
}

void Onion::channel_ok(jrp::misc::OrChannel *channel,vmp::Buf *payload)
{
    mutex_.unlock();
    try
    {
        crypto::X509_Wrap cout;
        channel->ssl_[0]->get_peer_x509(&cout);
        channel->permits_=accept_(this,channel->cid_,cout.address());
    }
    catch(vmp::exception &x)
    {
        vmp::error("jrp::misc::Onion::channel_ok()[accept_] %s",x.what());  
    }
    mutex_.lock();
    if(channel->permits_ > 0)
    {
        channel_status_internal(channel,jrp::misc::or_status_wait);
        channel->msg_orreply(jrp::misc::japi("orchannel"),jrp::status_ok,"",payload);
    }
    else
    {
        channel_status_internal(channel,jrp::misc::or_status_close);
        channel->msg_orreply(jrp::misc::japi("orchannel"),jrp::status_resource_accessdenied);
        close_channel_route(channel,jrp::status_ok);
    }
}

void Onion::channel_err(jrp::misc::OrChannel *channel,vmp::str cmd,vmp_int status,vmp::str msg,vmp_bool crypt)
{
    json::Json json;
    vmp_index cid=channel->cid_;
    if(msg == "")
        msg=jrp::msg_status(status);
    mutex_.unlock();
    try
    {
        channelerr_(this,cid,status,msg);
    }
    catch(vmp::exception &x)
    {
        vmp::error("jrp::misc::Onion::channel_err()[channelerr_] %s",x.what());  
    }
    mutex_.lock();
    channel_status_internal(channel,jrp::misc::or_status_close);
    if(crypt)
        channel->msg_orreply_crypt(cmd,status,msg);
    else
        channel->msg_orreply(cmd,status,msg);
    close_channel_route(channel,jrp::status_ok);
}

vmp_bool Onion::relay_verify(jrp::misc::OrChannel *channel,vmp::str target)
{
    vmp_index cid=channel->cid_;
    vmp_bool ret;
    channel->chain_.push_back(target);
    channel->orstatus_=jrp::misc::or_status_relaychannel;
    mutex_.unlock();
    try
    {
        ret=relayvrfy_(this,cid);
    }
    catch(vmp::exception &x)
    {
        vmp::error("jrp::misc::Onion::relay_verify()[relayvrfy_] %s",x.what());  
    }
    mutex_.lock();
    return ret;
}

void Onion::close_channel_cb(jrp::misc::OrChannel *channel,vmp_int status,vmp::str msg)
{
    vmp_index cid=channel->cid_;
    if((channel->orstatus_ == jrp::misc::or_status_source) || (channel->orstatus_ == jrp::misc::or_status_channel))
    {
        mutex_.unlock();
        try
        {
            closesource_(this,cid,status,msg);
        }
        catch(vmp::exception &x)
        {
            vmp::error("jrp::misc::Onion::close_channel_cb()[closesource_] %s",x.what());  
        }
        mutex_.lock();
    }
    else if((channel->orstatus_ == jrp::misc::or_status_relay) || (channel->orstatus_ == jrp::misc::or_status_accept) || (channel->orstatus_ == jrp::misc::or_status_wait) || (channel->orstatus_ == jrp::misc::or_status_relaychannel))
    {
        mutex_.unlock();
        try
        {
            closerelay_(this,cid,status,msg);
        }
        catch(vmp::exception &x)
        {
            vmp::error("jrp::misc::Onion::close_channel_cb()[closerelay_] %s",x.what());  
        }
        mutex_.lock();
    }
    else if (channel->orstatus_ == jrp::misc::or_status_target)
    {    
        mutex_.unlock();
        try
        {
            closetarget_(this,cid,status,msg);
        }
        catch(vmp::exception &x)
        {
            vmp::error("jrp::misc::Onion::close_channel_cb()[closetarget_] %s",x.what());  
        }
        mutex_.lock();
    }
}

vmp_bool Onion::target(jrp::misc::OrChannel *channel)
{
    vmp_index cid=channel->cid_;
    vmp_bool ret;
    mutex_.unlock();
    try
    {
        ret=targetvrfy_(this,cid);
    }
    catch(vmp::exception &x)
    {
        vmp::error("jrp::misc::Onion::target()[targetvrfy_] %s",x.what());  
    }
    mutex_.lock();
    if(ret)
    {
        channel_status_internal(channel,jrp::misc::or_status_target);
        channel->msg_orreply_crypt(jrp::misc::japi("ortarget"),jrp::status_ok);
        active_ping(channel);
        mutex_.unlock();
        try
        {
            target_(this,cid);
        }
        catch(vmp::exception &x)
        {
            vmp::error("jrp::misc::Onion::target()[target_] %s",x.what());  
        }
        mutex_.lock();
    }
    return ret;
}

void Onion::target_recv(jrp::misc::OrChannel *channel,json::JsonObj *jdata,vmp::Buf *payload)
{
    vmp_index cid=channel->cid_;
    mutex_.unlock();
    try
    {
        recvtarget_(this,cid,jdata,payload);
    }
    catch(vmp::exception &x)
    {
        vmp::error("jrp::misc::Onion::recvtarget()[recvtarget_] %s",x.what());  
    }
    mutex_.lock();
}

}}}

