/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 09/05/2025
*/

#ifndef VAMPIRIA_JRP_MISC_H

#define VAMPIRIA_JRP_MISC_H 1

namespace vampiria { namespace jrp { namespace misc {

//! Returns the full name of the data type jrp::misc(example jrp::misc::'jtype')
/*!
    @param jtype short name data type json
    @return full name data type jrp::misc 
*/
vmp::str japi(vmp::str jtype);

//!Common JRP Message Management Interface
class JrpApi_I
{
    private:
        vmp::vector<vmp::str> types_;/*!<List of managed types*/
    protected:
        //!Used in subclasses to insert types to be managed
        /*!
            @param type input type
        */
        void addtype(vmp::str type);
    public:
        vmp::thread::Mutex mutex_;/*!<Mutex object*/
        
        //! A constructor
        JrpApi_I();
        
        //! A destructor
        virtual ~JrpApi_I();
        
        //!Record jrp request information in jrpcommon
        /*!
            @param jrp common object
            @param permits Permissions to be assigned
        */
        virtual void register_common(jrp::JrpCommon *common,vmp::str permits="*")=0;
        
        //!Handles a jrp request
        /*!
            @param jreq jreq structure associated
            @param payload payload data
            @return true if on request and managed, otherwise false
        */
        vmp_bool management(jrp::JrpReq *jreq,vmp::Buf *payload);
        
        //!Implementation in the management subclass
        /*!
            @param jreq jreq structure associated
            @param payload payload data
        */
        virtual void management_impl(jrp::JrpReq *jreq,vmp::Buf *payload);
        
        //! Manages response messages
        /*!
            @param jreq jreq structure associated
            @param jdata input data
            @param payload payload data
            @return true if on request and managed, otherwise false
        */
        vmp_bool management_response(jrp::JrpReq *jreq,json::JsonObj *jdata,vmp::Buf *payload);
        
        //!Implementation in the management_response subclass
        /*!
            @param jreq jreq structure associated
            @param jdata input data
            @param payload payload data
        */
        virtual void management_response_impl(jrp::JrpReq *jreq,json::JsonObj *jdata,vmp::Buf *payload);
        
        //! Manages push messages
        /*!
            @param jreq jreq structure associated
            @param jdata input data
            @param payload payload data
            @return true if on request and managed, otherwise false
        */
        vmp_bool management_push(jrp::JrpReq *jreq,json::JsonObj *jdata,vmp::Buf *payload);
        
        //!Implementation in the management_push subclass
        /*!
            @param jreq jreq structure associated
            @param jdata input data
            @param payload payload data
        */
        virtual void management_push_impl(jrp::JrpReq *jreq,json::JsonObj *jdata,vmp::Buf *payload);
        
        //! Handles kill messages
        /*!
            @param jreq jreq structure associated
            @return true if on request and managed, otherwise false
        */
        vmp_bool management_kill(jrp::JrpReq *jreq);
        
        //!Implementation in the management_kill subclass
        /*!
            @param jreq jreq structure associated
        */
        virtual void management_kill_impl(jrp::JrpReq *jreq);
        
        //! Handles close messages
        /*!
            @param jreq jreq structure associated
            @return true if on request and managed, otherwise false
        */
        vmp_bool management_close(jrp::JrpReq *jreq);
        
        //!Implementation in the management_close subclass
        /*!
            @param jreq jreq structure associated
        */
        virtual void management_close_impl(jrp::JrpReq *jreq);
};

}}}

#endif

#include "misc/utils.h"
#include "misc/status.h"
#include "misc/onion.h"


