/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 15/05/2020
 */

#include "event.h"

namespace vampiria { namespace event {

SimplexRef::SimplexRef()
{
}

SimplexRef::~SimplexRef()
{
}

SimplexUI::SimplexUI(event::Manager *manager):UI(manager)
{
    set_event(0,0);
}
        
SimplexUI::~SimplexUI()
{
}

vmp::str SimplexUI::identity(event::Cell *cell)
{
    vmp::str ret;
    SimplexRef *sevent=cell->event<SimplexRef>();
    vmp::unicode::str_write(&ret,"Simplex event [id=%s]",sevent->id_.c_str());
    return ret;
}

void SimplexUI::close_event(event::Cell *cell)
{
    SimplexRef *sevent=cell->event<SimplexRef>();
    sevent->evt_simplex_close();
}
        
void SimplexUI::free_ref(event::Cell *cell)
{
    SimplexRef *sevent=cell->event<SimplexRef>();
    sevent->evt_simplex_free();
    sevent->id_="";
    sref_.free(sevent);
}

void SimplexUI::set_event(event::EVTCB event,event::EVTCB cevent)
{
    event_=event;
    cevent_=cevent;
}

event::Cell *SimplexUI::new_event(vmp::str id)
{
    event::Cell *cell;
    manager_->lock();
    SimplexRef *sevent=sref_.get();
    try
    {
        cell=sevent->evt_simplex_new(this,event_,cevent_);
        sevent->id_=id;
    }
    catch(vmp::exception &x)
    {
        sref_.free(sevent);
        manager_->unlock();
        vmp::except_s(x.what()); 
    }
    manager_->unlock();
    return cell;
}

void SimplexUI::active(event::Cell *cell)
{
    SimplexRef *sevent=cell->event<SimplexRef>();
    event::Manager *manager=cell->get_manager();
    manager->lock();
    try
    {
        if(manager->cell_update(cell))
           sevent->evt_simplex_active();    
    }
    catch(vmp::exception &x)
    {
        manager->unlock();
        vmp::except_s(x.what()); 
    }
    manager->unlock();
}

vmp::str SimplexUI::id(event::Cell *cell)
{
    SimplexRef *sevent=cell->event<SimplexRef>();
    event::Manager *manager=cell->get_manager();
    manager->lock();
    vmp::str id=sevent->id_;
    manager->unlock();
    return id;
}

}}

