/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 22/10/2024
 */

#ifndef VAMPIRIA_EVENT_LIB_H

#define VAMPIRIA_EVENT_LIB_H 1

namespace vampiria { namespace event {

class Cell;
class Manager;
class UI;

typedef void (*EVTCB)(event::Cell *cell);/*!< Simplex type callback*/
typedef void (*EVTCBCLOSE)(event::Cell *cell,vmp_int retcode,vmp::str retmsg);/*!< Close event callback*/
typedef void (*EVTCBBUF)(event::Cell *cell,vmp::Buf *buf);/*<!Event Buffer type callback*/
typedef void (*EVTCBSTR)(event::Cell *cell,vmp::str data); /*!< Event string type callback*/

//!Empty EVTCB callback
void empty_ev(event::Cell *cell);

//!Empty EVTCB callback
void empty_close_ev(event::Cell *cell,vmp_int retcode,vmp::str retmsg);

//!Empty EVTCBBUF callback
void empty_buf_ev(event::Cell *cell,vmp::Buf *buf);

//!Empty EVTCBSTR callback
void empty_str_ev(event::Cell *cell,vmp::str data);

//!Base class event
class Event
{
    protected:
        vmp_int priority_; /*!<priority of the event execution,Initial value when the event is created*/
    public:
        //!A Constructor
        Event();

        //!A destructor
        ~Event();

        vmp_bool active_;/*!<event is active?*/
        
        vmp_int fd_;/*!< Filedescriptor associated*/

        event::Cell *cell_;/*!<Cell associated*/
       
        vmp::Table<vmp::str,event::Cell *> evtsubs_;/*!<Associated sub-events.If the main event ends, its sottoevents will also be finished*/
        event::Cell *master_;/*!<master event associated,When the master event is closed, it is set to 0 */
        vmp::str sid_;/*!Subevent id*/
        
       //!Create a new event base
       /*!
           @param  ui user interface (see Class UI)
           @param  fd filedescriptor associated with the event
           @param  read  function performed in the loop
           @param  close function performed at the end of the event
           @return the new cell associated with the event
       */
       event::Cell *evt_new(event::UI *ui,vmp_int fd,event::EVTCB read,event::EVTCB close);
       
       //!Active o deactive event
       /*!
           @param active true or false
           @sa active
       */
       void evt_active(vmp_bool active);
       
       //! Close event
       void evt_close();
       
       //! Free event
       void evt_free();
};

//!Event Pipe base event.
class EventPipe:public event::Event
{
    public:
       //!A Constructor
       EventPipe();

       //!A Destructor
       ~EventPipe();

       vmp_int wfd_;/*!<Write filedescriptor*/

       //!Create pipe event
       /*!
            @param  ui user interface (see Class UI)
            @param  read  function performed in the loop
            @param  close function performed at the end of the event
            @return the new cell associated with the event
       */
       event::Cell *evt_pipe_new(event::UI *ui,event::EVTCB read,event::EVTCB close);
       
       //!Close write filedescriptor
       void evt_pipe_closew();
       
       //! Close pipe event
       void evt_pipe_close();

       //! Free pipe event
       void evt_pipe_free();
};

}}

#endif

