/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 06/09/2024
 */
 
#include "crypto.h"

namespace vampiria { namespace crypto {

Ctx::Ctx()
{
    ctx_=0;
}
        
Ctx::~Ctx()
{
    reset();
}

void Ctx::reset()
{
    if(ctx_ != 0)
    {
        SSL_CTX_free(ctx_);
        ctx_=0;
    }
}

void Ctx::copy(crypto::Ctx *ctx)
{
    vmp::except_check_pointer((void *)ctx,"crypto::Ctx::copy(ctx=NULL)");
    reset();
    ctx_=ctx->ctx_;
    if(ctx_ != 0)
        SSL_CTX_up_ref(ctx_);
}

void Ctx::get_x509(crypto::X509_Wrap *cout)
{
    vmp::except_check_pointer((void *) cout,"crypto::Ctx_I::get_x509(x509=NULL)");
    vmp::except_check_pointer((void *)ctx_,"crypto::Ctx::get_x509() null context");
    STACK_OF(X509) *chain;
    SSL_CTX_get0_chain_certs(ctx_,&chain);
    vmp::except_check_pointer((void *)chain,"No certificate was presented by the peer or no connection was established");
    vmp_size num = sk_X509_num(chain);
    crypto::X509_Wrap *tmp;
    for(vmp_index i=0;i<num;i++)
    {
        if(i == 0)
        {
            cout->set(sk_X509_value(chain,i));
            tmp=cout;
        }
        else
        {
            tmp->parent_=new X509_Wrap();
            tmp=tmp->parent_;
            tmp->set(sk_X509_value(chain,i));
        }
    }
}

Ctx_I::Ctx_I()
{
}

Ctx_I::~Ctx_I()
{
}

void crypto::Ctx_I::build_ctx()
{
    if(ctx_.ctx_ == 0)
    {
        ctx_.ctx_=init();
        if(ctx_.ctx_ == 0)
            vmp::except("crypto::Ctx_I::build_ctx() error %s",crypto::err_string().c_str());
    }    
}

crypto::Ctx *Ctx_I::get()
{
    if(ctx_.ctx_ == 0)
        vmp::except_s("crypto::Ctx_I::get() null context"); 
    return &ctx_;
}

}}

