#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 13/09/2024

##@package vmp_packet.websocket
#
# Wrapper c++ namespace vampiria::packet::http

import vmp

from vmp_packet_ import websocket as ws

WebSocketCode_Normal=ws.WebSocketCode_Normal
WebSocketCode_Shutdown=ws.WebSocketCode_Shutdown
WebSocketCode_Protocol=ws.WebSocketCode_Protocol
WebSocketCode_Type=ws.WebSocketCode_Type
WebSocketCode_Utf8=ws.WebSocketCode_Utf8
WebSocketCode_Policy=ws.WebSocketCode_Policy
WebSocketCode_Big=ws.WebSocketCode_Big
WebSocketCode_Extension=ws.WebSocketCode_Extension
WebSocketCode_Unexpected=ws.WebSocketCode_Unexpected

WebSocketCode_reason=ws.WebSocketCode_reason

P_WEBSOCKET_FRAMING=ws.P_WEBSOCKET_FRAMING
WebSocket_Framing_D=ws.WebSocket_Framing_D

def WebSocket_Framing(fin=None,rsv1=None,rsv2=None,rsv3=None,opcode=None,masking_key="",payload=""):
  p=WebSocket_Framing_D()
  if fin != None :
    p.set("fin",fin)
  if rsv1 != None:
    p.set("rsv1",rsv1)
  if rsv2 != None:
    p.set("rsv2",rsv2);
  if rsv3 != None:  
    p.set("rsv3",rsv3);
  if opcode != None:  
    p.set("opcode",opcode);
  if masking_key != "":
    p.set("mask","set");
    p.set("masking_key",masking_key);
  p.set("payload",payload);
  return p;
  
