/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 13/09/2024
 */
 
#include  "vmp.h"
#include  "pylib.h"
#include  "packet.h"

#ifndef VAMPIRIA_PY_PACKET_H

#define VAMPIRIA_PY_PACKET_H 1

//!Python wrapper of the c++ namespace vampiria::packet in vmp_packet.(see c++ doc)
/*!
    Const c++ packet type in packet.h:<BR>P_RAW,P_ETHERNET,P_ARP, P_IPV4,P_UDP,P_TCP<BR>
    Function list in packet.h:<BR>
        packet_free(),arpsub_str_generic(),Ipv4_integrity_check(),Ipv4_adjust_check(),Tcp_integrity_check(),Tcp_adjust_check(),
        Udp_integrity_check(),Udp_adjust_check(),Arp_Ethernet_Ipv4_D(),Ethernet_D(),Ipv4_D(),Raw_D(),Tcp_D(),Udp_D()<BR>
    Function list in packet/datatypes/types.h:<BR>ethertype_str_generic(),ipproto_str_generic(),arphtype_str_generic()
                                                          
*/
/*!
    Packet class in packet.h:<BR>No Constructor<BR>
    Packet member function list:<BR>type(),subtype(),read(),write(),pseudo_header(),get(),set(),print(),next_type(),next(),prev(),payload()
    Packet operator list: / , []
*/
/*!
     PacketHelper class in packet.h:<BR>Constructor PacketHelper()<BR>
     PacketHelper member function list:<BR>clone_type(),read(),write(),clone_hdr(),print_all()
*/
void packet_init(pylib::Module module);

//!Python wrapper of the c++ namespace vampiria::packet::http in vmp_packet.http(see c++ doc)
/*!
    Const c++ packet type in packet.h:<BR> P_HTTP_REQUEST,P_HTTP_RESPONSE
    Function list in packet.h:<BR>Http_Request_D(),Http_Response_D()
*/
/*!
    Const c++ packet type in packet/http/protocol.h:<BR>
    HttpCode_Continue,HttpCode_SwitchingProtocols,HttpCode_Processing,
    HttpCode_EarlyHints,HttpCode_OK,HttpCode_Created,HttpCode_Accepted,
    HttpCode_NonAuthoritativeInformation,HttpCode_NoContent,HttpCode_ResetContent,
    HttpCode_PartialContent,HttpCode_MultiStatus,HttpCode_AlreadyReported,
    HttpCode_IMUsed,HttpCode_MultipleChoices,HttpCode_MovedPermanently,
    HttpCode_Found,HttpCode_SeeOther,HttpCode_NotModified,HttpCode_UseProxy,
    HttpCode_TemporaryRedirect,HttpCode_PermanentRedirect,HttpCode_BadRequest,
    HttpCode_Unauthorized,HttpCode_PaymentRequired,HttpCode_Forbidden,
    HttpCode_NotFound,HttpCode_MethodNotAllowed,HttpCode_NotAcceptable,
    HttpCode_ProxyAuthenticationRequired,HttpCode_RequestTimeout,HttpCode_Conflict,
    HttpCode_Gone,HttpCode_LengthRequired,HttpCode_PreconditionFailed,
    HttpCode_PayloadTooLarge,HttpCode_URITooLong,HttpCode_UnsupportedMediaType,
    HttpCode_ExpectationFailed,HttpCode_ImATeapot,HttpCode_UnprocessableEntity,
    HttpCode_Locked,HttpCode_FailedDependency,HttpCode_UpgradeRequired,
    HttpCode_PreconditionRequired,HttpCode_TooManyRequests,
    HttpCode_RequestHeaderFieldsTooLarge,HttpCode_UnavailableForLegalReasons,
    HttpCode_InternalServerError,HttpCode_NotImplemented,HttpCode_BadGateway,
    HttpCode_ServiceUnavailable,HttpCode_GatewayTimeout,
    HttpCode_HTTPVersionNotSupported,HttpCode_VariantAlsoNegotiates,
    HttpCode_InsufficientStorage,HttpCode_LoopDetected,HttpCode_NotExtended,
    HttpCode_NetworkAuthenticationRequired
    <BR>
    Function list in packet/http/protocol.h:<BR>
    HttpCode_reason,HttpCode_isInformational,HttpCode_isSuccessful,
    HttpCode_isRedirection,HttpCode_isClientError,HttpCode_isServerError,
    HttpCode_isError,uri_encode,uri_decode
*/
/*!
     UriHelper class in packet/http/protocol.h:<BR>Constructor UriHelper() or UriHelper(uri) <BR>
     UriHelper member function list:<BR> reset(),read(),read(),init_abs(),
     init_authority(),init_path(),set_userinfo,type(),scheme(),user(),password(),
     host(),port(),path(),query(),fragment(),print,set_requesturi()
*/
/*!
     HeadersHelper class in packet/http/protocol.h:<BR>Constructor HeadersHelper() or HeadersHelper(headers) <BR>
     UriHelper member function list:<BR> headers(),reset(),read(),print(),
     set_requestheaders(),set_responseheaders()
*/
void packet_init_http(pylib::Module module);

//!Python wrapper of the c++ namespace vampiria::packet::websocket in vmp_packet.websocket(see c++ doc)
/*!
    Const c++ packet type in packet.h:<BR>P_WEBSOCKET_FRAMING
    Function list in packet.h:<BR>WebSocket_Framing_D(),WebSocket_Framing_Ping(),
    WebSocket_Framing_Pong(),WebSocket_Framing_close()
*/
/*!
    Const c++ packet type in packet/websocket.h:<BR> WebSocketCode_Normal,
    WebSocketCode_Shutdown,WebSocketCode_Protocol,WebSocketCode_Type,
    WebSocketCode_Utf8,WebSocketCode_Policy,WebSocketCode_Big,
    WebSocketCode_Extension,WebSocketCode_Unexpected
    Function list in packet/websocket.h:<BR>WebSocketCode_reason()
*/
void packet_init_websocket(pylib::Module module);

#endif

