/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 04/09/2024
 */

#include "packet_.h"

struct UriHelper_stub_Constructor:public pylib::Constructor<packet::http::UriHelper>
{
    packet::http::UriHelper *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
            return new packet::http::UriHelper();
        else if(args.size() == 1)
        {
            vmp::str uri=args.get<vmp::str>(0);
            return new packet::http::UriHelper(uri);
        }
        return 0;
    }
};

struct HeadersHelper_stub_Constructor:public pylib::Constructor<packet::http::HeadersHelper>
{
    packet::http::HeadersHelper *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
       if(args.size() == 0)
            return new packet::http::HeadersHelper();
        else if(args.size() == 1)
        {
            vmp::str headers=args.get<vmp::str>(0);
            return new packet::http::HeadersHelper(headers);
        }
        return 0;
    }
};

void packet_init_http(pylib::Module module)
{
    pylib::Module http=module.add_submodule("http");
    http.add_const<vmp_index>("HttpCode_Continue",packet::http::HttpCode_Continue);
    http.add_const<vmp_index>("HttpCode_SwitchingProtocols",packet::http::HttpCode_SwitchingProtocols);
    http.add_const<vmp_index>("HttpCode_Processing",packet::http::HttpCode_Processing);
    http.add_const<vmp_index>("HttpCode_EarlyHints",packet::http::HttpCode_EarlyHints);
    http.add_const<vmp_index>("HttpCode_OK",packet::http::HttpCode_OK);
    http.add_const<vmp_index>("HttpCode_Created",packet::http::HttpCode_Created);
    http.add_const<vmp_index>("HttpCode_Accepted",packet::http::HttpCode_Accepted);
    http.add_const<vmp_index>("HttpCode_NonAuthoritativeInformation",packet::http::HttpCode_NonAuthoritativeInformation);
    http.add_const<vmp_index>("HttpCode_NoContent",packet::http::HttpCode_NoContent);
    http.add_const<vmp_index>("HttpCode_ResetContent",packet::http::HttpCode_ResetContent);
    http.add_const<vmp_index>("HttpCode_PartialContent",packet::http::HttpCode_PartialContent);
    http.add_const<vmp_index>("HttpCode_MultiStatus",packet::http::HttpCode_MultiStatus);
    http.add_const<vmp_index>("HttpCode_AlreadyReported",packet::http::HttpCode_AlreadyReported);
    http.add_const<vmp_index>("HttpCode_IMUsed",packet::http::HttpCode_IMUsed);
    http.add_const<vmp_index>("HttpCode_MultipleChoices",packet::http::HttpCode_MultipleChoices);
    http.add_const<vmp_index>("HttpCode_MovedPermanently",packet::http::HttpCode_MovedPermanently);
    http.add_const<vmp_index>("HttpCode_Found",packet::http::HttpCode_Found);
    http.add_const<vmp_index>("HttpCode_SeeOther",packet::http::HttpCode_SeeOther);
    http.add_const<vmp_index>("HttpCode_NotModified",packet::http::HttpCode_NotModified);
    http.add_const<vmp_index>("HttpCode_UseProxy",packet::http::HttpCode_UseProxy);
    http.add_const<vmp_index>("HttpCode_TemporaryRedirect",packet::http::HttpCode_TemporaryRedirect);
    http.add_const<vmp_index>("HttpCode_PermanentRedirect",packet::http::HttpCode_PermanentRedirect);
    http.add_const<vmp_index>("HttpCode_BadRequest",packet::http::HttpCode_BadRequest);
    http.add_const<vmp_index>("HttpCode_Unauthorized",packet::http::HttpCode_Unauthorized);
    http.add_const<vmp_index>("HttpCode_PaymentRequired",packet::http::HttpCode_PaymentRequired);
    http.add_const<vmp_index>("HttpCode_Forbidden",packet::http::HttpCode_Forbidden);
    http.add_const<vmp_index>("HttpCode_NotFound",packet::http::HttpCode_NotFound);
    http.add_const<vmp_index>("HttpCode_MethodNotAllowed",packet::http::HttpCode_MethodNotAllowed);
    http.add_const<vmp_index>("HttpCode_NotAcceptable",packet::http::HttpCode_NotAcceptable);
    http.add_const<vmp_index>("HttpCode_ProxyAuthenticationRequired",packet::http::HttpCode_ProxyAuthenticationRequired);
    http.add_const<vmp_index>("HttpCode_RequestTimeout",packet::http::HttpCode_RequestTimeout);
    http.add_const<vmp_index>("HttpCode_Conflict",packet::http::HttpCode_Conflict);
    http.add_const<vmp_index>("HttpCode_Gone",packet::http::HttpCode_Gone);
    http.add_const<vmp_index>("HttpCode_LengthRequired",packet::http::HttpCode_LengthRequired);
    http.add_const<vmp_index>("HttpCode_PreconditionFailed",packet::http::HttpCode_PreconditionFailed);
    http.add_const<vmp_index>("HttpCode_PayloadTooLarge",packet::http::HttpCode_PayloadTooLarge);
    http.add_const<vmp_index>("HttpCode_URITooLong",packet::http::HttpCode_URITooLong);
    http.add_const<vmp_index>("HttpCode_UnsupportedMediaType",packet::http::HttpCode_UnsupportedMediaType);
    http.add_const<vmp_index>("HttpCode_RangeNotSatisfiable",packet::http::HttpCode_RangeNotSatisfiable);
http.add_const<vmp_index>("HttpCode_ExpectationFailed",packet::http::HttpCode_ExpectationFailed);
    http.add_const<vmp_index>("HttpCode_ImATeapot",packet::http::HttpCode_ImATeapot);
    http.add_const<vmp_index>("HttpCode_UnprocessableEntity",packet::http::HttpCode_UnprocessableEntity);
    http.add_const<vmp_index>("HttpCode_Locked",packet::http::HttpCode_Locked);
    http.add_const<vmp_index>("HttpCode_FailedDependency",packet::http::HttpCode_FailedDependency);
    http.add_const<vmp_index>("HttpCode_UpgradeRequired",packet::http::HttpCode_UpgradeRequired);
    http.add_const<vmp_index>("HttpCode_PreconditionRequired",packet::http::HttpCode_PreconditionRequired);
    http.add_const<vmp_index>("HttpCode_TooManyRequests",packet::http::HttpCode_TooManyRequests);
    http.add_const<vmp_index>("HttpCode_RequestHeaderFieldsTooLarge",packet::http::HttpCode_RequestHeaderFieldsTooLarge);
    http.add_const<vmp_index>("HttpCode_UnavailableForLegalReasons",packet::http::HttpCode_UnavailableForLegalReasons);
    http.add_const<vmp_index>("HttpCode_InternalServerError",packet::http::HttpCode_InternalServerError);
    http.add_const<vmp_index>("HttpCode_NotImplemented",packet::http::HttpCode_NotImplemented);
    http.add_const<vmp_index>("HttpCode_BadGateway",packet::http::HttpCode_BadGateway);
    http.add_const<vmp_index>("HttpCode_ServiceUnavailable",packet::http::HttpCode_ServiceUnavailable);
    http.add_const<vmp_index>("HttpCode_GatewayTimeout",packet::http::HttpCode_GatewayTimeout);
    http.add_const<vmp_index>("HttpCode_HTTPVersionNotSupported",packet::http::HttpCode_HTTPVersionNotSupported);
http.add_const<vmp_index>("HttpCode_VariantAlsoNegotiates",packet::http::HttpCode_VariantAlsoNegotiates);
http.add_const<vmp_index>("HttpCode_InsufficientStorage",packet::http::HttpCode_InsufficientStorage);
http.add_const<vmp_index>("HttpCode_LoopDetected",packet::http::HttpCode_LoopDetected);
http.add_const<vmp_index>("HttpCode_NotExtended",packet::http::HttpCode_NotExtended);
    http.add_const<vmp_index>("HttpCode_NetworkAuthenticationRequired",packet::http::HttpCode_NetworkAuthenticationRequired);
    http.def_("HttpCode_reason",packet::http::HttpCode_reason);
    http.def_("HttpCode_isInformational",packet::http::HttpCode_isInformational);
    http.def_("HttpCode_isSuccessful",packet::http::HttpCode_isSuccessful);
    http.def_("HttpCode_isRedirection",packet::http::HttpCode_isRedirection);
    http.def_("HttpCode_isClientError",packet::http::HttpCode_isClientError);
    http.def_("HttpCode_isServerError",packet::http::HttpCode_isServerError);
    http.def_("HttpCode_isError",packet::http::HttpCode_isError);
    http.def_("uri_encode",packet::http::uri_encode);
    http.def_("uri_decode",packet::http::uri_decode);
    
    http.add_const<vmp::str>("P_HTTP_REQUEST",packet::http::P_HTTP_REQUEST);
    http.add_const<vmp::str>("P_HTTP_RESPONSE",packet::http::P_HTTP_RESPONSE);
    http.def_("Http_Request_D",packet::http::Http_Request_D,false);
    http.def_("Http_Response_D",packet::http::Http_Response_D,false);
    
    pylib::Class<packet::http::UriHelper> uri=http.class_with_constructor<packet::http::UriHelper>("UriHelper",UriHelper_stub_Constructor());
    uri.def_("reset",&packet::http::UriHelper::reset);
    uri.def_("read",&packet::http::UriHelper::read);
    uri.def_("init_abs",&packet::http::UriHelper::init_abs);
    uri.def_("init_authority",&packet::http::UriHelper::init_authority);
    uri.def_("init_path",&packet::http::UriHelper::init_path);
    uri.def_("set_userinfo",&packet::http::UriHelper::set_userinfo);
    uri.def_("type",&packet::http::UriHelper::type);
    uri.def_("scheme",&packet::http::UriHelper::scheme);
    uri.def_("user",&packet::http::UriHelper::user);
    uri.def_("password",&packet::http::UriHelper::password);
    uri.def_("host",&packet::http::UriHelper::host);
    uri.def_("port",&packet::http::UriHelper::port);
    uri.def_("path",&packet::http::UriHelper::path);
    uri.def_("query",&packet::http::UriHelper::query,false);
    uri.def_("fragment",&packet::http::UriHelper::fragment,false);
    uri.def_("print",&packet::http::UriHelper::print);
    uri.def_("set_requesturi",&packet::http::UriHelper::set_requesturi);

    pylib::Class<packet::http::HeadersHelper> hdr=http.class_with_constructor<packet::http::HeadersHelper>("HeadersHelper",HeadersHelper_stub_Constructor());
    hdr.def_("headers",&packet::http::HeadersHelper::headers,false);
    hdr.def_("reset",&packet::http::HeadersHelper::reset);
    hdr.def_("read",&packet::http::HeadersHelper::read);
    hdr.def_("print",&packet::http::HeadersHelper::print);
    hdr.def_("set_requestheaders",&packet::http::HeadersHelper::set_requestheaders);
    hdr.def_("set_responseheaders",&packet::http::HeadersHelper::set_responseheaders);
}

