#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 04/09/2024

##@package vmp_packet.http
#
# Wrapper c++ namespace vampiria::packet::http

import vmp

from vmp_packet_ import http as h

HttpCode_Continue=h.HttpCode_Continue
HttpCode_SwitchingProtocols=h.HttpCode_SwitchingProtocols
HttpCode_Processing=h.HttpCode_Processing
HttpCode_EarlyHints=h.HttpCode_EarlyHints
HttpCode_OK=h.HttpCode_OK
HttpCode_Created=h.HttpCode_Created
HttpCode_Accepted=h.HttpCode_Accepted
HttpCode_NonAuthoritativeInformation=h.HttpCode_NonAuthoritativeInformation
HttpCode_NoContent=h.HttpCode_NoContent 
HttpCode_ResetContent=h.HttpCode_ResetContent
HttpCode_PartialContent=h.HttpCode_PartialContent
HttpCode_MultiStatus=h.HttpCode_MultiStatus
HttpCode_AlreadyReported=h.HttpCode_AlreadyReported
HttpCode_IMUsed=h.HttpCode_IMUsed
HttpCode_MultipleChoices=h.HttpCode_MultipleChoices
HttpCode_MovedPermanently=h.HttpCode_MovedPermanently
HttpCode_Found=h.HttpCode_Found
HttpCode_SeeOther=h.HttpCode_SeeOther
HttpCode_NotModified=h.HttpCode_NotModified
HttpCode_UseProxy=h.HttpCode_UseProxy
HttpCode_TemporaryRedirect=h.HttpCode_TemporaryRedirect
HttpCode_PermanentRedirect=h.HttpCode_PermanentRedirect
HttpCode_BadRequest=h.HttpCode_BadRequest
HttpCode_Unauthorized=h.HttpCode_Unauthorized
HttpCode_PaymentRequired=h.HttpCode_PaymentRequired
HttpCode_Forbidden=h.HttpCode_Forbidden
HttpCode_NotFound=h.HttpCode_NotFound
HttpCode_MethodNotAllowed=h.HttpCode_MethodNotAllowed
HttpCode_NotAcceptable=h.HttpCode_NotAcceptable
HttpCode_ProxyAuthenticationRequired=h.HttpCode_ProxyAuthenticationRequired
HttpCode_RequestTimeout=h.HttpCode_RequestTimeout
HttpCode_Conflict=h.HttpCode_Conflict
HttpCode_Gone=h.HttpCode_Gone
HttpCode_LengthRequired=h.HttpCode_LengthRequired
HttpCode_PreconditionFailed=h.HttpCode_PreconditionFailed
HttpCode_PayloadTooLarge=h.HttpCode_PayloadTooLarge
HttpCode_URITooLong=h.HttpCode_URITooLong
HttpCode_UnsupportedMediaType=h.HttpCode_UnsupportedMediaType
HttpCode_RangeNotSatisfiable=h.HttpCode_RangeNotSatisfiable
HttpCode_ExpectationFailed=h.HttpCode_ExpectationFailed
HttpCode_ImATeapot=h.HttpCode_ImATeapot
HttpCode_UnprocessableEntity=h.HttpCode_UnprocessableEntity
HttpCode_Locked=h.HttpCode_Locked
HttpCode_FailedDependency=h.HttpCode_FailedDependency
HttpCode_UpgradeRequired=h.HttpCode_UpgradeRequired
HttpCode_PreconditionRequired=h.HttpCode_PreconditionRequired
HttpCode_TooManyRequests=h.HttpCode_TooManyRequests
HttpCode_RequestHeaderFieldsTooLarge=h.HttpCode_RequestHeaderFieldsTooLarge
HttpCode_UnavailableForLegalReasons=h.HttpCode_UnavailableForLegalReasons
HttpCode_InternalServerError=h.HttpCode_InternalServerError
HttpCode_NotImplemented=h.HttpCode_NotImplemented 
HttpCode_BadGateway=h.HttpCode_BadGateway
HttpCode_ServiceUnavailable=h.HttpCode_ServiceUnavailable
HttpCode_GatewayTimeout=h.HttpCode_GatewayTimeout
HttpCode_HTTPVersionNotSupported=h.HttpCode_HTTPVersionNotSupported
HttpCode_VariantAlsoNegotiates=h.HttpCode_VariantAlsoNegotiates
HttpCode_InsufficientStorage=h.HttpCode_InsufficientStorage
HttpCode_LoopDetected=h.HttpCode_LoopDetected
HttpCode_NotExtended=h.HttpCode_NotExtended
HttpCode_NetworkAuthenticationRequired=h.HttpCode_NetworkAuthenticationRequired

HttpCode_reason=h.HttpCode_reason
HttpCode_isInformational=h.HttpCode_isInformational
HttpCode_isSuccessful=h.HttpCode_isSuccessful
HttpCode_isRedirection=h.HttpCode_isRedirection
HttpCode_isClientError=h.HttpCode_isClientError
HttpCode_isServerError=h.HttpCode_isServerError
HttpCode_isError=h.HttpCode_isError
uri_encode=h.uri_encode
uri_decode=h.uri_decode

UriHelper=h.UriHelper
HeadersHelper=h.HeadersHelper
P_HTTP_REQUEST=h.P_HTTP_REQUEST
P_HTTP_RESPONSE=h.P_HTTP_RESPONSE
Http_Request_D=h.Http_Request_D
Http_Response_D=h.Http_Response_D

##see c++ comment
def Http_Request(method="GET",uri=None,version="HTTP/1.1",headers=None,body=""):
  p=Http_Request_D()
  p.set("method",method)
  if uri != None:
    uri.set_requesturi(p)
  p.set("version",version)
  if headers != None:  
    headers.set_requestheaders(p)
  p.set("body",body)
  return p

##see c++ comment  
def Http_Response(version="HTTP/1.1",code=HttpCode_OK,reason=HttpCode_reason(HttpCode_OK),headers=None,body=""):
  p=Http_Response_D()
  p.set("version",version)
  p.set("code",str(code))
  p.set("reason",reason)
  if headers != None:  
    headers.set_responseheaders(p)
  p.set("body",body)
  return p

