/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 05/11/2024
 */

#include "net_.h"

class PySocksUI:public net::SocksUI
{
   public:
        PySocksUI(event::Manager *manager);
        ~PySocksUI();
        
        pylib::PyCall pyaccept_;
        pylib::PyCall pylclose_;
        pylib::PyCall pyclose_;
        
        pylib::PyCall pynoauth_;
        pylib::PyCall pyuserpass_;
        
        pylib::PyCall pycmdconnect_;
        pylib::PyCall pycrecv_;
        
        pylib::PyCall pycmdbind_;
        pylib::PyCall pybrecv_;
        
        pylib::PyCall pycmdudpassociate_;
        pylib::PyCall pyudprecv_;
};

PySocksUI::PySocksUI(event::Manager *manager):net::SocksUI(manager)
{
}

PySocksUI::~PySocksUI()
{
}

struct stub_socksui:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            event::Cell *cell=args.get<event::Cell *>(0);
            return pylib::Converter<PySocksUI *>(cell->ui<PySocksUI>(),false);

        }
        return 0;
    }
};

struct SocksUI_Constructor:public pylib::Constructor<PySocksUI>
{
    PySocksUI *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 1)
         {
              event::Manager *manager=args.get<event::Manager *>(0);
              return new PySocksUI(manager);
         }
         return 0;
    }
};

void socks_pyaccept(event::Cell *cell,event::Cell *child)
{
    PySocksUI *socksui=cell->ui<PySocksUI>();
    pylib::CArgs cargs(2);
    cargs.add<event::Cell *>(cell,false);
    cargs.add<event::Cell *>(child,false);
    socksui->pyaccept_.call(cargs);
}

void socks_pylclose(event::Cell *cell)
{
    PySocksUI *socksui=cell->ui<PySocksUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    socksui->pylclose_.call(cargs);    
}

void socks_pyclose(event::Cell *cell)
{
    PySocksUI *socksui=cell->ui<PySocksUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    socksui->pyclose_.call(cargs);  
}

struct stub_SocksUI_set_tcp_event:public pylib::Member_def<PySocksUI>
{
    pylib::Objref *def(PySocksUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 3)
        {
            net::EVTCBACCEPT accept;
            event::EVTCB lclose;
            event::EVTCB close;
            
            args.get_callable(0,instance->pyaccept_);
            args.get_callable(1,instance->pylclose_);
            args.get_callable(2,instance->pyclose_);
            
            if(pylib::is_none(instance->pyaccept_.ref()))
                accept=0;
            else 
                accept=socks_pyaccept;
            if(pylib::is_none(instance->pylclose_.ref()))
                lclose=0;
            else 
                lclose=socks_pylclose;
            if(pylib::is_none(instance->pyclose_.ref()))
                close=0;
            else 
                close=socks_pyclose;
            instance->set_tcp_event(accept,lclose,close);
            return pylib::retnone();
        }
        return 0;
    }
};

vmp_uint socks_pynoauth(event::Cell *cell)
{
    PySocksUI *socksui=cell->ui<PySocksUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    return socksui->pynoauth_.call(cargs).get<vmp_uint>();  
}

vmp_uint socks_pyuserpass(event::Cell *cell,vmp::str user,vmp::str password)
{
    PySocksUI *socksui=cell->ui<PySocksUI>();
    pylib::CArgs cargs(3);
    cargs.add<event::Cell *>(cell,false);
    cargs.add<vmp::str>(user);
    cargs.add<vmp::str>(password);
    return socksui->pyuserpass_.call(cargs).get<vmp_uint>();
}

struct stub_SocksUI_set_auths:public pylib::Member_def<PySocksUI>
{
    pylib::Objref *def(PySocksUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            net::SOCKSCBNOAUTH noauth;
            net::SOCKSCBUSERPASS userpass;
            
            args.get_callable(0,instance->pynoauth_);
            args.get_callable(1,instance->pyuserpass_);
            
            if(pylib::is_none(instance->pynoauth_.ref()))
                noauth=0;
            else 
                noauth=socks_pynoauth;
            if(pylib::is_none(instance->pyuserpass_.ref()))
                userpass=0;
            else 
                userpass=socks_pyuserpass;
            instance->set_auths(noauth,userpass);
            return pylib::retnone();         
        }
        return 0;
    }
};

void socks_pycmdconnect(event::Cell *cell,net::Address *address)
{
    PySocksUI *socksui=cell->ui<PySocksUI>();
    pylib::CArgs cargs(2);
    cargs.add<event::Cell *>(cell,false);
    cargs.add<net::Address *>(address,false);
    socksui->pycmdconnect_.call(cargs);
}

void socks_pycrecv(event::Cell *cell,vmp::Buf *buf)
{
    PySocksUI *socksui=cell->ui<PySocksUI>();
    pylib::CArgs cargs(2);
    cargs.add<event::Cell *>(cell,false);
    cargs.add<vmp::Buf *>(buf,false);
    socksui->pycrecv_.call(cargs);
}

struct stub_SocksUI_set_connect_event:public pylib::Member_def<PySocksUI>
{
    pylib::Objref *def(PySocksUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            net::SOCKSCBREQUEST cmdconnect;
            event::EVTCBBUF crecv;
            
            args.get_callable(0,instance->pycmdconnect_);
            args.get_callable(1,instance->pycrecv_);
            
            if(pylib::is_none(instance->pycmdconnect_.ref()))
                cmdconnect=0;
            else 
                cmdconnect=socks_pycmdconnect;
            if(pylib::is_none(instance->pycrecv_.ref()))
                crecv=0;
            else 
                crecv=socks_pycrecv;
            instance->set_connect_event(cmdconnect,crecv);
            return pylib::retnone(); 
        }
        return 0;
    }
};

void socks_pycmdbind(event::Cell *cell,net::Address *address)
{
    PySocksUI *socksui=cell->ui<PySocksUI>();
    pylib::CArgs cargs(2);
    cargs.add<event::Cell *>(cell,false);
    cargs.add<net::Address *>(address,false);
    socksui->pycmdbind_.call(cargs);
}

void socks_pybrecv(event::Cell *cell,vmp::Buf *buf)
{
    PySocksUI *socksui=cell->ui<PySocksUI>();
    pylib::CArgs cargs(2);
    cargs.add<event::Cell *>(cell,false);
    cargs.add<vmp::Buf *>(buf,false);
    socksui->pybrecv_.call(cargs);
}

struct stub_SocksUI_set_bind_event:public pylib::Member_def<PySocksUI>
{
    pylib::Objref *def(PySocksUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            net::SOCKSCBREQUEST cmdbind;
            event::EVTCBBUF brecv;
            
            args.get_callable(0,instance->pycmdbind_);
            args.get_callable(1,instance->pybrecv_);
            
            if(pylib::is_none(instance->pycmdbind_.ref()))
                cmdbind=0;
            else 
                cmdbind=socks_pycmdbind;
            if(pylib::is_none(instance->pybrecv_.ref()))
                brecv=0;
            else 
                brecv=socks_pybrecv;
            instance->set_bind_event(cmdbind,brecv);
            return pylib::retnone(); 
        }
        return 0;
    }
};

void socks_pycmdudpassociate(event::Cell *cell,net::Address *address)
{
    PySocksUI *socksui=cell->ui<PySocksUI>();
    pylib::CArgs cargs(2);
    cargs.add<event::Cell *>(cell,false);
    cargs.add<net::Address *>(address,false);
    socksui->pycmdudpassociate_.call(cargs);
}

void socks_pyudprecv(event::Cell *cell,vmp::Buf *buf,net::Address *peer)
{
    PySocksUI *socksui=cell->ui<PySocksUI>();
    pylib::CArgs cargs(3);
    cargs.add<event::Cell *>(cell,false);
    cargs.add<vmp::Buf *>(buf,false);
    cargs.add<net::Address *>(peer,false);
    socksui->pyudprecv_.call(cargs);
}

struct stub_SocksUI_set_udpassociate_event:public pylib::Member_def<PySocksUI>
{
    pylib::Objref *def(PySocksUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        net::SOCKSCBREQUEST cmdudpassociate;
        net::EVTCBRECVFROM udprecv;
        if(args.size() == 2)
        {
            args.get_callable(0,instance->pycmdudpassociate_);
            args.get_callable(1,instance->pyudprecv_);
            
            if(pylib::is_none(instance->pycmdudpassociate_.ref()))
                cmdudpassociate=0;
            else 
                cmdudpassociate=socks_pycmdudpassociate;
            if(pylib::is_none(instance->pyudprecv_.ref()))
                udprecv=0;
            else 
                udprecv=socks_pyudprecv;
            instance->set_udpassociate_event(cmdudpassociate,udprecv);
            return pylib::retnone();
        }
        else if(args.size() == 3)
        {
            args.get_callable(0,instance->pycmdudpassociate_);
            args.get_callable(1,instance->pyudprecv_);
            
            if(pylib::is_none(instance->pycmdudpassociate_.ref()))
                cmdudpassociate=0;
            else 
                cmdudpassociate=socks_pycmdudpassociate;
            if(pylib::is_none(instance->pyudprecv_.ref()))
                udprecv=0;
            else 
                udprecv=socks_pyudprecv;
            vmp_size udpmaxsize=args.get<vmp_size>(2);
            instance->set_udpassociate_event(cmdudpassociate,udprecv,udpmaxsize);
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_SocksUI_reply_error:public pylib::Member_def<PySocksUI>
{
    pylib::Objref *def(PySocksUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            event::Cell *cell=args.get<event::Cell *>(0);
            vmp_byte result=args.get<vmp_byte>(1);
            instance->reply_error(cell,result);
            return pylib::retnone();
        }
        else if(args.size() == 3)
        {
            event::Cell *cell=args.get<event::Cell *>(0);
            vmp_byte result=args.get<vmp_byte>(1);
            vmp::str msg=args.get<vmp::str>(2);
            instance->reply_error(cell,result,msg);
            return pylib::retnone();
        }
        return 0;
    }
};

/*struct stub_SocksUI_:public pylib::Member_def<PySocksUI>
{
    pylib::Objref *def(PySocksUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        return 0;
    }
};*/

void net_init_socksui(pylib::Module module)
{
    //Wrapper cell->ui()
    module.def_with_stub("socksui",stub_socksui());
    
    //net/socks.h
    pylib::Class<PySocksUI> socksui=module.class_with_constructor<PySocksUI>("SocksUI",SocksUI_Constructor());
    socksui.def_with_stub("set_tcp_event",stub_SocksUI_set_tcp_event());
    socksui.def_("set_timeout",&PySocksUI::set_timeout);
    socksui.def_with_stub("set_auths",stub_SocksUI_set_auths());
    socksui.def_with_stub("set_connect_event",stub_SocksUI_set_connect_event());
    socksui.def_with_stub("set_bind_event",stub_SocksUI_set_bind_event());
    socksui.def_with_stub("set_udpassociate_event",stub_SocksUI_set_udpassociate_event());
    socksui.def_("new_server",&PySocksUI::new_server,false);
    socksui.def_with_stub("reply_error",stub_SocksUI_reply_error());
    socksui.def_("reply_connect",&PySocksUI::reply_connect); 
    socksui.def_("reply_bind_listen",&PySocksUI::reply_bind_listen); 
    socksui.def_("reply_bind_connect",&PySocksUI::reply_bind_connect); 
    socksui.def_("reply_udpassociate",&PySocksUI::reply_udpassociate);
    socksui.def_("send",&PySocksUI::send);
    socksui.def_("sendTo",&PySocksUI::sendTo);
    socksui.def_("localaddr",&PySocksUI::localaddr,false); 
    socksui.def_("peeraddr",&PySocksUI::peeraddr,false);
    socksui.def_("connection_type",&PySocksUI::connection_type);
    socksui.def_("connection_strtype",&PySocksUI::connection_strtype);
    socksui.def_("cstatus",&PySocksUI::cstatus);
    socksui.def_("userid",&PySocksUI::userid);
    socksui.def_("permits",&PySocksUI::permits);
    socksui.def_("socks_command",&PySocksUI::socks_command);
    socksui.def_("socks_command_str",&PySocksUI::socks_command_str);
    socksui.def_("socks_address",&PySocksUI::socks_address,false);
    socksui.def_("socks_udpbind",&PySocksUI::socks_udpbind,false);
}

