/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 26/04/2025
*/

#include "jrp_.h"

struct Misc_Passwd_stub_Constructor:public pylib::Constructor<jrp::misc::Passwd>
{
    jrp::misc::Passwd *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            crypto::Ctx_Peer_Web *ctx=args.get<crypto::Ctx_Peer_Web *>(0);
            return new jrp::misc::Passwd(ctx);
        }
        return 0;
    }
};

struct stub_misc_passwd_register_common:public pylib::Member_def<jrp::misc::Passwd>
{
    pylib::Objref *def(jrp::misc::Passwd *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            jrp::JrpCommon *common=(jrp::JrpCommon *)args.get<PyJrpCommon *>(0);
            instance->register_common(common);
            return pylib::retnone();
        }
        else if(args.size() == 2)
        {
            jrp::JrpCommon *common=(jrp::JrpCommon *)args.get<PyJrpCommon *>(0);
            vmp::str permits=args.get<vmp::str>(1);
            instance->register_common(common,permits);
            return pylib::retnone();
        }
        return 0;
    }
};

struct Misc_User_stub_Constructor:public pylib::Constructor<jrp::misc::User>
{
    jrp::misc::User *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            crypto::Ctx_Peer_Web *ctx=args.get<crypto::Ctx_Peer_Web *>(0);
            return new jrp::misc::User(ctx);
        }
        return 0;
    }
};

struct stub_misc_user_register_common:public pylib::Member_def<jrp::misc::User>
{
    pylib::Objref *def(jrp::misc::User *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            jrp::JrpCommon *common=(jrp::JrpCommon *)args.get<PyJrpCommon *>(0);
            instance->register_common(common);
            return pylib::retnone();
        }
        else if(args.size() == 2)
        {
            jrp::JrpCommon *common=(jrp::JrpCommon *)args.get<PyJrpCommon *>(0);
            vmp::str permits=args.get<vmp::str>(1);
            instance->register_common(common,permits);
            return pylib::retnone();
        }
        return 0;
    }
};

struct Misc_Peer_stub_Constructor:public pylib::Constructor<jrp::misc::Peer>
{
    jrp::misc::Peer *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            crypto::Ctx_Peer *ctx=args.get<crypto::Ctx_Peer *>(0);
            return new jrp::misc::Peer(ctx);
        }
        return 0;
    }
};

struct stub_misc_peer_register_common:public pylib::Member_def<jrp::misc::Peer>
{
    pylib::Objref *def(jrp::misc::Peer *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            jrp::JrpCommon *common=(jrp::JrpCommon *)args.get<PyJrpCommon *>(0);
            instance->register_common(common);
            return pylib::retnone();
        }
        else if(args.size() == 2)
        {
            jrp::JrpCommon *common=(jrp::JrpCommon *)args.get<PyJrpCommon *>(0);
            vmp::str permits=args.get<vmp::str>(1);
            instance->register_common(common,permits);
            return pylib::retnone();
        }
        return 0;
    }
};

struct Misc_ConnectStatus_stub_Constructor:public pylib::Constructor<jrp::misc::ConnectStatus>
{
    jrp::misc::ConnectStatus *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            PyJrpUI *jrpui;
            PyWssJrpUI *wssjrpui;
            if(args.is_none(0))
                jrpui=0;
            else
                jrpui=args.get<PyJrpUI *>(0);
            if(args.is_none(1))
                wssjrpui=0;
            else
                wssjrpui=args.get<PyWssJrpUI *>(1);
            return new jrp::misc::ConnectStatus(jrpui,wssjrpui);
        }
        return 0;
    }
};

struct stub_misc_ConnectStatus_register_common:public pylib::Member_def<jrp::misc::ConnectStatus>
{
    pylib::Objref *def(jrp::misc::ConnectStatus *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            jrp::JrpCommon *common=(jrp::JrpCommon *)args.get<PyJrpCommon *>(0);
            instance->register_common(common);
            return pylib::retnone();
        }
        else if(args.size() == 2)
        {
            jrp::JrpCommon *common=(jrp::JrpCommon *)args.get<PyJrpCommon *>(0);
            vmp::str permits=args.get<vmp::str>(1);
            instance->register_common(common,permits);
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_misc_Logs_register_common:public pylib::Member_def<jrp::misc::Logs>
{
    pylib::Objref *def(jrp::misc::Logs *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            jrp::JrpCommon *common=(jrp::JrpCommon *)args.get<PyJrpCommon *>(0);
            instance->register_common(common);
            return pylib::retnone();
        }
        else if(args.size() == 2)
        {
            jrp::JrpCommon *common=(jrp::JrpCommon *)args.get<PyJrpCommon *>(0);
            vmp::str permits=args.get<vmp::str>(1);
            instance->register_common(common,permits);
            return pylib::retnone();
        }
        return 0;
    }
};
void jrp_misc_utils(pylib::Module module)
{
    module.def_("japi",jrp::misc::japi);
    
    pylib::Class<jrp::misc::Passwd> passwd=module.class_with_constructor<jrp::misc::Passwd>("Passwd",Misc_Passwd_stub_Constructor());
    passwd.def_with_stub("register_common",stub_misc_passwd_register_common());
    passwd.def_("management",&jrp::misc::Passwd::management);
    
    pylib::Class<jrp::misc::User> user=module.class_with_constructor<jrp::misc::User>("User",Misc_User_stub_Constructor());
    user.def_with_stub("register_common",stub_misc_user_register_common());
    user.def_("management",&jrp::misc::User::management);
    
    pylib::Class<jrp::misc::Peer> peer=module.class_with_constructor<jrp::misc::Peer>("Peer",Misc_Peer_stub_Constructor());
    peer.def_with_stub("register_common",stub_misc_peer_register_common());
    peer.def_("management",&jrp::misc::Peer::management);
    
    pylib::Class<jrp::misc::ConnectStatus> connectstatus=module.class_with_constructor<jrp::misc::ConnectStatus>("ConnectStatus",Misc_ConnectStatus_stub_Constructor());
    connectstatus.def_with_stub("register_common",stub_misc_ConnectStatus_register_common());
    connectstatus.def_("management",&jrp::misc::ConnectStatus::management);

    pylib::Class<jrp::misc::Logs> logs=module.class_<jrp::misc::Logs>("Logs");
    logs.def_("set_logdir",&jrp::misc::Logs::set_logdir);
    logs.def_with_stub("register_common",stub_misc_Logs_register_common());
    logs.def_("management",&jrp::misc::Logs::management);
}

