/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 22/07/2025
*/

#include "jrp_.h"

void caction_event(event::Cell *cell)
{
    cell->remvar<jrp::misc::Onion>("onion");
    cell->remvar<jrp::misc::OrChannel>("channel");
    delete cell->remvar<pylib::PyCall *>("action");
}

class PyOnion:public jrp::misc::Onion
{
    public:
        PyOnion(jrp::JrpUI *ui);
        ~PyOnion();
        
        pylib::PyCall pyconnect_;
        pylib::PyCall pyrecvsource_;
        pylib::PyCall pyconnecterr_;
        pylib::PyCall pyclosesource_;
        
        pylib::PyCall pyaccept_;
        pylib::PyCall pychannelerr_;
        pylib::PyCall pyrelayvrfy_;
        pylib::PyCall pyrelay_;
        pylib::PyCall pycloserelay_;
        
        pylib::PyCall pytargetvrfy_;
        pylib::PyCall pytarget_;
        pylib::PyCall pyrecvtarget_;
        pylib::PyCall pyclosetarget_;
};

PyOnion::PyOnion(jrp::JrpUI *ui)
{
    init_onion(ui);
    actionui_->set_event(jrp::misc::action_event,caction_event);
}
        
PyOnion::~PyOnion()
{
    destroy_onion();
}

struct Misc_Onion_stub_Constructor:public pylib::Constructor<PyOnion>
{
    PyOnion *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            jrp::JrpUI *ui=(jrp::JrpUI *) args.get<PyJrpUI *>(0);
            return new PyOnion(ui);
        }
        return 0;
    }
};

struct stub_misc_onion_register_common:public pylib::Member_def<PyOnion>
{
    pylib::Objref *def(PyOnion *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            jrp::JrpCommon *common=(jrp::JrpCommon *)args.get<PyJrpCommon *>(0);
            instance->register_common(common);
            return pylib::retnone();
        }
        else if(args.size() == 2)
        {
            jrp::JrpCommon *common=(jrp::JrpCommon *)args.get<PyJrpCommon *>(0);
            vmp::str permits=args.get<vmp::str>(1);
            instance->register_common(common,permits);
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_misc_onion_register_management:public pylib::Member_def<PyOnion>
{
    pylib::Objref *def(PyOnion *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            jrp::JrpCommon *common=(jrp::JrpCommon *)args.get<PyJrpCommon *>(0);
            instance->register_management(common);
            return pylib::retnone();
        }
        else if(args.size() == 2)
        {
            jrp::JrpCommon *common=(jrp::JrpCommon *)args.get<PyJrpCommon *>(0);
            vmp::str permits=args.get<vmp::str>(1);
            instance->register_management(common,permits);
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_misc_onion_set_status:public pylib::Member_def<PyOnion>
{
    pylib::Objref *def(PyOnion *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            jrp::misc::Status *status=args.get<jrp::misc::Status *>(0);
            instance->set_status(status);
            return pylib::retnone();
        }
        else if(args.size() == 2)
        {
            jrp::misc::Status *status=args.get<jrp::misc::Status *>(0);
            vmp::str permits=args.get<vmp::str>(1);
            instance->set_status(status,permits);
            return pylib::retnone();
        }
        return 0;
    }
};

void onion_connectcb(jrp::misc::Onion *onion,vmp_index cid)
{
    PyOnion *pyonion=(PyOnion *) onion;
    pylib::CArgs cargs(2);
    cargs.add<PyOnion *>(pyonion,false);
    cargs.add<vmp_index>(cid);
    pyonion->pyconnect_.call(cargs);
}

void onion_recvsourcecb(jrp::misc::Onion *onion,vmp_index cid,json::JsonObj *jdata,vmp::Buf *payload)
{
    PyOnion *pyonion=(PyOnion *) onion;
    pylib::CArgs cargs(4);
    cargs.add<PyOnion *>(pyonion,false);
    cargs.add<vmp_index>(cid);
    cargs.add<json::JsonObj *>(jdata,false);
    cargs.add<vmp::Buf *>(payload,false);
    pyonion->pyrecvsource_.call(cargs);
}

void onion_pyconnecterrcb(jrp::misc::Onion *onion,vmp_index cid,vmp::str peer,vmp_int status,vmp::str msg)
{
    PyOnion *pyonion=(PyOnion *) onion;
    pylib::CArgs cargs(5);
    cargs.add<PyOnion *>(pyonion,false);
    cargs.add<vmp_index>(cid);
    cargs.add<vmp::str>(peer);
    cargs.add<vmp_int>(status);
    cargs.add<vmp::str>(msg);
    pyonion->pyconnecterr_.call(cargs);
}

void onion_closesourcecb(jrp::misc::Onion *onion,vmp_index cid,vmp_int status,vmp::str msg)
{
    PyOnion *pyonion=(PyOnion *) onion;
    pylib::CArgs cargs(4);
    cargs.add<PyOnion *>(pyonion,false);
    cargs.add<vmp_index>(cid);
    cargs.add<vmp_int>(status);
    cargs.add<vmp::str>(msg);
    pyonion->pyclosesource_.call(cargs);
}

struct stub_misc_onion_set_source_cb:public pylib::Member_def<PyOnion>
{
    pylib::Objref *def(PyOnion *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 4)
        {
            jrp::misc::ONIONCB connect;
            jrp::misc::ONIONRECVCB recvsource;
            jrp::misc::ONIONERRCB connecterr;
            jrp::misc::ONIONCLOSECB closesource;
            
            args.get_callable(0,instance->pyconnect_);
            args.get_callable(1,instance->pyrecvsource_);
            args.get_callable(2,instance->pyconnecterr_);
            args.get_callable(3,instance->pyclosesource_);
            
            if(pylib::is_none(instance->pyconnect_.ref()))
               connect=0;
            else 
               connect=onion_connectcb;
            if(pylib::is_none(instance->pyrecvsource_.ref()))
               recvsource=0;
            else 
               recvsource=onion_recvsourcecb;
            if(pylib::is_none(instance->pyconnecterr_.ref()))
               connecterr=0;
            else 
               connecterr=onion_pyconnecterrcb;
            if(pylib::is_none(instance->pyclosesource_.ref()))
               closesource=0;
            else 
               closesource=onion_closesourcecb;
            instance->set_source_cb(connect,recvsource,connecterr,closesource);
            return pylib::retnone();
        }
        return 0;
    }
};

vmp_uint onion_acceptcb(jrp::misc::Onion *onion,vmp_index cid,vmp::str peer)
{
    PyOnion *pyonion=(PyOnion *) onion;
    pylib::CArgs cargs(3);
    cargs.add<PyOnion *>(pyonion,false);
    cargs.add<vmp_index>(cid);
    cargs.add<vmp::str>(peer);
    return pyonion->pyaccept_.call(cargs).get<vmp_uint>();
}

void onion_channelerrcb(jrp::misc::Onion *onion,vmp_index cid,vmp_int status,vmp::str msg)
{
    PyOnion *pyonion=(PyOnion *) onion;
    pylib::CArgs cargs(4);
    cargs.add<PyOnion *>(pyonion,false);
    cargs.add<vmp_index>(cid);
    cargs.add<vmp_int>(status);
    cargs.add<vmp::str>(msg);
    pyonion->pychannelerr_.call(cargs);
}

vmp_bool onion_relayvrfycb(jrp::misc::Onion *onion,vmp_index cid)
{
    PyOnion *pyonion=(PyOnion *) onion;
    pylib::CArgs cargs(2);
    cargs.add<PyOnion *>(pyonion,false);
    cargs.add<vmp_index>(cid);
    return pyonion->pyrelayvrfy_.call(cargs).get<vmp_bool>();
}

void onion_relaycb(jrp::misc::Onion *onion,vmp_index cid)
{
    PyOnion *pyonion=(PyOnion *) onion;
    pylib::CArgs cargs(2);
    cargs.add<PyOnion *>(pyonion,false);
    cargs.add<vmp_index>(cid);
    pyonion->pyrelay_.call(cargs);
}

void onion_closerelaycb(jrp::misc::Onion *onion,vmp_index cid,vmp_int status,vmp::str msg)
{
    PyOnion *pyonion=(PyOnion *) onion;
    pylib::CArgs cargs(4);
    cargs.add<PyOnion *>(pyonion,false);
    cargs.add<vmp_index>(cid);
    cargs.add<vmp_int>(status);
    cargs.add<vmp::str>(msg);
    pyonion->pycloserelay_.call(cargs);
}

struct stub_misc_onion_set_channel_cb:public pylib::Member_def<PyOnion>
{
    pylib::Objref *def(PyOnion *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 5)
        {
            jrp::misc::ONIONACCEPTCB accept;
            jrp::misc::ONIONCLOSECB channelerr;
            jrp::misc::ONIONVRFYCB relayvrfy;
            jrp::misc::ONIONCB relay;
            jrp::misc::ONIONCLOSECB closerelay;
            
            args.get_callable(0,instance->pyaccept_);
            args.get_callable(1,instance->pychannelerr_);
            args.get_callable(2,instance->pyrelayvrfy_);
            args.get_callable(3,instance->pyrelay_);
            args.get_callable(4,instance->pycloserelay_);
            
            if(pylib::is_none(instance->pyaccept_.ref()))
               accept=0;
            else 
               accept=onion_acceptcb;
            if(pylib::is_none(instance->pychannelerr_.ref()))
               channelerr=0;
            else 
               channelerr=onion_channelerrcb;
            if(pylib::is_none(instance->pyrelayvrfy_.ref()))
               relayvrfy=0;
            else 
               relayvrfy=onion_relayvrfycb;
            if(pylib::is_none(instance->pyrelay_.ref()))
               relay=0;
            else 
               relay=onion_relaycb;
            if(pylib::is_none(instance->pycloserelay_.ref()))
               closerelay=0;
            else 
               closerelay=onion_closerelaycb;
            instance->set_channel_cb(accept,channelerr,relayvrfy,relay,closerelay);
            return pylib::retnone();
        }
        return 0;
    }
};

vmp_bool onion_targetvrfycb(jrp::misc::Onion *onion,vmp_index cid)
{
    PyOnion *pyonion=(PyOnion *) onion;
    pylib::CArgs cargs(2);
    cargs.add<PyOnion *>(pyonion,false);
    cargs.add<vmp_index>(cid);
    return pyonion->pytargetvrfy_.call(cargs).get<vmp_bool>();
}

void onion_targetcb(jrp::misc::Onion *onion,vmp_index cid)
{
    PyOnion *pyonion=(PyOnion *) onion;
    pylib::CArgs cargs(2);
    cargs.add<PyOnion *>(pyonion,false);
    cargs.add<vmp_index>(cid);
    pyonion->pytarget_.call(cargs);
}

void onion_recvtargetcb(jrp::misc::Onion *onion,vmp_index cid,json::JsonObj *jdata,vmp::Buf *payload)
{
    PyOnion *pyonion=(PyOnion *) onion;
    pylib::CArgs cargs(4);
    cargs.add<PyOnion *>(pyonion,false);
    cargs.add<vmp_index>(cid);
    cargs.add<json::JsonObj *>(jdata,false);
    cargs.add<vmp::Buf *>(payload,false);
    pyonion->pyrecvtarget_.call(cargs);
}

void onion_closetargetcb(jrp::misc::Onion *onion,vmp_index cid,vmp_int status,vmp::str msg)
{
    PyOnion *pyonion=(PyOnion *) onion;
    pylib::CArgs cargs(4);
    cargs.add<PyOnion *>(pyonion,false);
    cargs.add<vmp_index>(cid);
    cargs.add<vmp_int>(status);
    cargs.add<vmp::str>(msg);
    pyonion->pyclosetarget_.call(cargs);
}

struct stub_misc_onion_set_target_cb:public pylib::Member_def<PyOnion>
{
    pylib::Objref *def(PyOnion *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 4)
        {
            jrp::misc::ONIONVRFYCB targetvrfy;
            jrp::misc::ONIONCB target;
            jrp::misc::ONIONRECVCB recvtarget;
            jrp::misc::ONIONCLOSECB closetarget;
            
            args.get_callable(0,instance->pytargetvrfy_);
            args.get_callable(1,instance->pytarget_);
            args.get_callable(2,instance->pyrecvtarget_);
            args.get_callable(3,instance->pyclosetarget_);
            
            if(pylib::is_none(instance->pytargetvrfy_.ref()))
               targetvrfy=0;
            else 
               targetvrfy=onion_targetvrfycb;
            if(pylib::is_none(instance->pytarget_.ref()))
               target=0;
            else 
               target=onion_targetcb;
            if(pylib::is_none(instance->pyrecvtarget_.ref()))
               recvtarget=0;
            else 
               recvtarget=onion_recvtargetcb;
            if(pylib::is_none(instance->pyclosetarget_.ref()))
               closetarget=0;
            else 
               closetarget=onion_closetargetcb;
            instance->set_target_cb(targetvrfy,target,recvtarget,closetarget);
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_misc_onion_channel_send:public pylib::Member_def<PyOnion>
{
    pylib::Objref *def(PyOnion *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            vmp_index cid=args.get<vmp_index>(0);
            json::JsonObj *jdata=args.get<json::JsonObj *>(1);
            instance->channel_send(cid,jdata);
            return pylib::retnone();
        }
        else if(args.size() == 3)
        {
            vmp_index cid=args.get<vmp_index>(0);
            json::JsonObj *jdata=args.get<json::JsonObj *>(1);
            vmp::Buf *payload=args.get<vmp::Buf *>(2);
            instance->channel_send(cid,jdata,payload);
            return pylib::retnone();
        }
        return 0;
    }
};

void onion_action(jrp::misc::Onion *onion,vmp_index cid)
{
    event::Cell *cell=onion->actionevt_channel(cid);
    pylib::PyCall *pycall=cell->getvar<pylib::PyCall>("action");
    if(pycall != 0)
    {
        pylib::CArgs cargs(2);
        cargs.add<PyOnion *>((PyOnion *)onion,false);
        cargs.add<vmp_index>(cid);
        pycall->call(cargs);
    }
}

struct stub_misc_onion_channel_action:public pylib::Member_def<PyOnion>
{
    pylib::Objref *def(PyOnion *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        
        if(args.size() == 2 || args.size() == 3)
        {
            pylib::PyCall *action=new pylib::PyCall();
            vmp_index cid=args.get<vmp_index>(0);
            jrp::misc::ONIONCB cb;
            try
            {
                args.get_callable(1,(*action));
                if(pylib::is_none((*action).ref()))
                    cb=0;    
                else
                    cb=onion_action;
            }
            catch(vmp::exception &x)
            {
                delete action;
                args.arg_error();
            }
            vmp::time::Time time=0;
            if(args.size() == 3)
                time=args.get<vmp::time::Time>(2);
            if(time > 0)
            {
                instance->channel_action(cid,cb,time);
                event::Cell *cell=instance->actionevt_channel(cid);
                if(cell != 0)
                {
                    pylib::PyCall *tmp=cell->remvar<pylib::PyCall>("action");
                    if(tmp != 0)
                        delete tmp;
                    cell->setvar<pylib::PyCall>("action",action);
                }
            }
            else
            {
                instance->actionevt_disable(cid);
                pylib::CArgs cargs(2);
                cargs.add<PyOnion *>(instance,false);
                cargs.add<vmp_index>(cid);
                action->call(cargs);
                delete action;    
            }
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_misc_onion_channel_close:public pylib::Member_def<PyOnion>
{
    pylib::Objref *def(PyOnion *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            vmp_index cid=args.get<vmp_index>(0);
            vmp_int status=args.get<vmp_int>(1);
            instance->channel_close(cid,status);
            return pylib::retnone();
        }
        else if(args.size() == 3)
        {
            vmp_index cid=args.get<vmp_index>(0);
            vmp_int status=args.get<vmp_int>(1);
            vmp::str msg=args.get<vmp::str>(2);
            instance->channel_close(cid,status,msg);
            return pylib::retnone();
        }
        return 0;
    }
};

void jrp_misc_onion(pylib::Module module)
{
    module.add_const<vmp_int>("or_status_init",jrp::misc::or_status_init);
    module.add_const<vmp_int>("or_status_channel",jrp::misc::or_status_channel);
    module.add_const<vmp_int>("or_status_channelrelay",jrp::misc::or_status_channelrelay);
    module.add_const<vmp_int>("or_status_channeltarget",jrp::misc::or_status_channeltarget);
    module.add_const<vmp_int>("or_status_source",jrp::misc::or_status_source);
    module.add_const<vmp_int>("or_status_accept",jrp::misc::or_status_accept);
    module.add_const<vmp_int>("or_status_wait",jrp::misc::or_status_wait);
    module.add_const<vmp_int>("or_status_relaychannel",jrp::misc::or_status_relaychannel);
    module.add_const<vmp_int>("or_status_relay",jrp::misc::or_status_relay);
    module.add_const<vmp_int>("or_status_target",jrp::misc::or_status_target);
    module.add_const<vmp_int>("or_status_close",jrp::misc::or_status_close);
    
    module.def_("japi_orchannel",jrp::misc::japi_orchannel);
    module.def_("japi_orreply",jrp::misc::japi_orreply);
    module.def_("japi_orrelay",jrp::misc::japi_orrelay);
    module.def_("japi_ortarget",jrp::misc::japi_ortarget);
    module.def_("japi_ordata",jrp::misc::japi_ordata);
    module.def_("japi_orchannelclose",jrp::misc::japi_orchannelclose);
    module.def_("japi_orping",jrp::misc::japi_orping);
    
    module.def_("or_msg_status",jrp::misc::or_msg_status);
    
    pylib::Class<PyOnion> onion=module.class_with_constructor<PyOnion>("Onion",Misc_Onion_stub_Constructor());
    onion.def_with_stub("register_common",stub_misc_onion_register_common());
    onion.def_("management",&PyOnion::management);
    onion.def_("management_response",&PyOnion::management_response);
    onion.def_("management_push",&PyOnion::management_push);
    onion.def_("management_kill",&PyOnion::management_kill);
    onion.def_("management_close",&PyOnion::management_close);
    onion.def_with_stub("register_management",stub_misc_onion_register_management());
    onion.def_("optimeout",&PyOnion::optimeout);
    onion.def_("ping",&PyOnion::ping);
    onion.def_("keyexpired",&PyOnion::keyexpired);
    onion.def_("maxchannel",&PyOnion::maxchannel);
    onion.def_("set_params",&PyOnion::set_params);
    onion.def_with_stub("set_status",stub_misc_onion_set_status());
    onion.def_with_stub("set_source_cb",stub_misc_onion_set_source_cb());
    onion.def_with_stub("set_channel_cb",stub_misc_onion_set_channel_cb());
    onion.def_with_stub("set_target_cb",stub_misc_onion_set_target_cb());
    onion.def_("channel_status",&PyOnion::channel_status);
    onion.def_("channel_permits",&PyOnion::channel_permits);
    onion.def_("channel_chain",&PyOnion::channel_chain);
    onion.def_("channel_next",&PyOnion::channel_next);
    onion.def_("channel_prev",&PyOnion::channel_prev);
    onion.def_("channel_peer_x509",&PyOnion::channel_peer_x509);
    onion.def_("channel_target",&PyOnion::channel_target);
    onion.def_("channel_source",&PyOnion::channel_source);
    onion.def_("channel_relay",&PyOnion::channel_relay);
    onion.def_("channel",&PyOnion::channel);
    onion.def_with_stub("channel_send",stub_misc_onion_channel_send());
    onion.def_with_stub("channel_action",stub_misc_onion_channel_action());
    onion.def_("channel_action_disable",&PyOnion::channel_action_disable);
    onion.def_with_stub("channel_close",stub_misc_onion_channel_close());
}

