/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 31/03/2025
 */
 
#include "jrp_.h"

struct stub_jrpreq_push:public pylib::Member_def<jrp::JrpReq>
{
    pylib::Objref *def(jrp::JrpReq *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            json::JsonObj *outputs=args.get<json::JsonObj *>(0);
            instance->push(outputs);
            return pylib::retnone();
        }
        else if(args.size() == 2)
        {
            json::JsonObj *outputs=args.get<json::JsonObj *>(0);
            vmp::Buf *payload=0;
            if(!args.is_none(1))
                payload=args.get<vmp::Buf *>(1);
            instance->push(outputs,payload);
            return pylib::retnone();
        } 
        return 0;
    }  
};

struct stub_jrpreq_response:public pylib::Member_def<jrp::JrpReq>
{
    pylib::Objref *def(jrp::JrpReq *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            json::JsonObj *outputs=args.get<json::JsonObj *>(0);
            instance->response(outputs);
            return pylib::retnone();
        }
        else if(args.size() == 2)
        {
            json::JsonObj *outputs=args.get<json::JsonObj *>(0);
            vmp::Buf *payload=0;
            if(!args.is_none(1))
                payload=args.get<vmp::Buf *>(1);
            instance->response(outputs,payload);
            return pylib::retnone();
        } 
        return 0;
    }  
};

struct stub_jrpreq_close:public pylib::Member_def<jrp::JrpReq>
{
    pylib::Objref *def(jrp::JrpReq *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp_int status=args.get<vmp_int>(0);
            instance->close(status);
            return pylib::retnone();
        }
        else if(args.size() == 2)
        {
            vmp_int status=args.get<vmp_int>(0);
            vmp::str msg=args.get<vmp::str>(1);
            instance->close(status,msg);
            return pylib::retnone();
        } 
        return 0;
    }  
};

struct stub_jrpreq_request_oper:public pylib::Member_def<jrp::JrpReq>
{
    pylib::Objref *def(jrp::JrpReq *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            json::JsonObj *oper=args.get<json::JsonObj *>(0);
            instance->request_oper(oper);
            return pylib::retnone();
        }
        else if(args.size() == 2)
        {
            json::JsonObj *oper=args.get<json::JsonObj *>(0);
            vmp::Buf *bin=0;
            if(!args.is_none(1))
                bin=args.get<vmp::Buf *>(1);
            instance->request_oper(oper,bin);
            return pylib::retnone();
        } 
        return 0;
    }
};

struct stub_jrpreq_set_timeout:public pylib::Member_def<jrp::JrpReq>
{
    pylib::Objref *def(jrp::JrpReq *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
        {
            instance->set_timeout();
            return pylib::retnone();
        }
        else if(args.size() == 1)
        {
            vmp::time::Time timeout=args.get<vmp::time::Time>(0);
            instance->set_timeout(timeout);
            return pylib::retnone();
        } 
        return 0;
    }
};

struct stub_jrpreq_push_oper:public pylib::Member_def<jrp::JrpReq>
{
    pylib::Objref *def(jrp::JrpReq *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            json::JsonObj *oper=args.get<json::JsonObj *>(0);
            json::JsonObj *jdata=args.get<json::JsonObj *>(1);
            instance->push_oper(oper,jdata);
            return pylib::retnone();
        }
        else if(args.size() == 2)
        {
            json::JsonObj *oper=args.get<json::JsonObj *>(0);
            json::JsonObj *jdata=args.get<json::JsonObj *>(1);
            vmp::Buf *bin=0;
            if(!args.is_none(2))
                bin=args.get<vmp::Buf *>(2);
            instance->push_oper(oper,jdata,bin);
            return pylib::retnone();
        } 
        return 0;
    }
};

void jrp_jrpreq(pylib::Module module)
{
    pylib::Class<jrp::JrpReq> jrpreq=module.class_no_constructor<jrp::JrpReq>("JrpReq");
    jrpreq.def_("common",&jrp::JrpReq::common,false);
    jrpreq.def_("type",&jrp::JrpReq::type);
    jrpreq.def_("cell",&jrp::JrpReq::cell,false);
    jrpreq.def_("rid",&jrp::JrpReq::rid);
    jrpreq.def_("jdata_type",&jrp::JrpReq::jdata_type);
    jrpreq.def_("key",&jrp::JrpReq::key);
    jrpreq.def_("jdata_json",&jrp::JrpReq::jdata_json,false);
    jrpreq.def_("jdata_root",&jrp::JrpReq::jdata_root,false);
    jrpreq.def_("status",&jrp::JrpReq::status);
    jrpreq.def_("msg",&jrp::JrpReq::msg);
    jrpreq.def_("alloc_internal",&jrp::JrpReq::alloc_internal);
    jrpreq.def_("alloc",&jrp::JrpReq::alloc);
    jrpreq.def_("release_internal",&jrp::JrpReq::release_internal);
    jrpreq.def_("release",&jrp::JrpReq::release);
    jrpreq.def_with_stub("set_timeout",stub_jrpreq_set_timeout());
    jrpreq.def_with_stub("push",stub_jrpreq_push());
    jrpreq.def_with_stub("response",stub_jrpreq_response());
    jrpreq.def_("kill",&jrp::JrpReq::kill);
    jrpreq.def_with_stub("close",stub_jrpreq_close());
    jrpreq.def_with_stub("request_oper",stub_jrpreq_request_oper());
    jrpreq.def_with_stub("push_oper",stub_jrpreq_push_oper());
    jrpreq.def_("kill_oper",&jrp::JrpReq::kill_oper);
    jrpreq.def_("send_from_oper",&jrp::JrpReq::send_from_oper);
}

