/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 01/07/2025
 */
 
#include "jrp_.h"

PyJrpUI::PyJrpUI(event::Manager *manager,crypto::Ctx_Peer *ctx,jrp::JrpCommon *jrpcommon,vmp::utils::Logger *logger,vmp::time::Time ctimeout):jrp::JrpUI(manager,ctx,jrpcommon,logger,ctimeout)
{
}

PyJrpUI::~PyJrpUI()
{
}

struct stub_jrpui:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            event::Cell *cell=args.get<event::Cell *>(0);
            return pylib::Converter<PyJrpUI *>(cell->ui<PyJrpUI>(),false);
        }
        return 0;
    }
};

struct JrpUI_Constructor:public pylib::Constructor<PyJrpUI>
{
    PyJrpUI *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 3)
         {
             event::Manager *manager=args.get<event::Manager *>(0);
             crypto::Ctx_Peer *ctx=args.get<crypto::Ctx_Peer *>(1);
             PyJrpCommon *common=args.get<PyJrpCommon *>(2);
             return new PyJrpUI(manager,ctx,(jrp::JrpCommon *)common);
         }
         else if(args.size() == 4)
         {
             event::Manager *manager=args.get<event::Manager *>(0);
             crypto::Ctx_Peer *ctx=args.get<crypto::Ctx_Peer *>(1);
             PyJrpCommon *common=args.get<PyJrpCommon *>(2);
             vmp::utils::Logger *logger=0;
             if(!args.is_none(3))
                logger=args.get<vmp::utils::Logger *>(3); 
             return new PyJrpUI(manager,ctx,(jrp::JrpCommon *)common,logger);
         }
         else if(args.size() == 5)
         {
             event::Manager *manager=args.get<event::Manager *>(0);
             crypto::Ctx_Peer *ctx=args.get<crypto::Ctx_Peer *>(1);
             PyJrpCommon *common=args.get<PyJrpCommon *>(2);
             vmp::utils::Logger *logger=0;
             if(!args.is_none(3))
                logger=args.get<vmp::utils::Logger *>(3);
             vmp::time::Time ctimeout=args.get<vmp::time::Time>(4);
             return new PyJrpUI(manager,ctx,(jrp::JrpCommon *)common,logger,ctimeout);
         }
         return 0;
    }
};

void jrpui_pytcpconnect(event::Cell *cell)
{
    PyJrpUI *jrpui=cell->ui<PyJrpUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    jrpui->pytcpconnect_.call(cargs);
}

void jrpui_pysessionclient(event::Cell *cell)
{
    PyJrpUI *jrpui=cell->ui<PyJrpUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    jrpui->pysessionclient_.call(cargs);
}

void jrpui_pycloseclient(event::Cell *cell)
{
    PyJrpUI *jrpui=cell->ui<PyJrpUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    jrpui->pycloseclient_.call(cargs);
}

struct stub_JrpUI_set_p2p_client_event:public pylib::Member_def<PyJrpUI>
{
    pylib::Objref *def(PyJrpUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 3)
        {
            event::EVTCB tcpconnect;
            event::EVTCB csession;
            event::EVTCB cclose;
            
            args.get_callable(0,instance->pytcpconnect_);
            args.get_callable(1,instance->pysessionclient_);
            args.get_callable(2,instance->pycloseclient_);
            
            if(pylib::is_none(instance->pytcpconnect_.ref()))
               tcpconnect=0;
            else 
               tcpconnect=jrpui_pytcpconnect;
            if(pylib::is_none(instance->pysessionclient_.ref()))
               csession=0;
            else 
               csession=jrpui_pysessionclient;
            if(pylib::is_none(instance->pycloseclient_.ref()))
               cclose=0;
            else 
               cclose=jrpui_pycloseclient;
            instance->set_p2p_client_event(tcpconnect,csession,cclose);
            return pylib::retnone();                      
        }
        return 0;
    }
};

void jrpui_pytcpaccept(event::Cell *cell,event::Cell *child)
{
    PyJrpUI *jrpui=cell->ui<PyJrpUI>();
    pylib::CArgs cargs(2);
    cargs.add<event::Cell *>(cell,false);
    cargs.add<event::Cell *>(child,false);
    jrpui->pytcpaccept_.call(cargs);
}

void jrpui_pysessionserver(event::Cell *cell)
{
    PyJrpUI *jrpui=cell->ui<PyJrpUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    jrpui->pysessionserver_.call(cargs);
}

void jrpui_pycloselisten(event::Cell *cell)
{
    PyJrpUI *jrpui=cell->ui<PyJrpUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    jrpui->pycloselisten_.call(cargs);
}

void jrpui_pycloseserver(event::Cell *cell)
{
    PyJrpUI *jrpui=cell->ui<PyJrpUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    jrpui->pycloseserver_.call(cargs);
}

struct stub_JrpUI_set_p2p_server_event:public pylib::Member_def<PyJrpUI>
{
    pylib::Objref *def(PyJrpUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 4)
        {
            net::EVTCBACCEPT tcpaccept;
            event::EVTCB ssession;
            event::EVTCB lclose;
            event::EVTCB sclose;
            
            args.get_callable(0,instance->pytcpaccept_);
            args.get_callable(1,instance->pysessionserver_);
            args.get_callable(2,instance->pycloselisten_);
            args.get_callable(3,instance->pycloseserver_);
            
            if(pylib::is_none(instance->pytcpaccept_.ref()))
               tcpaccept=0;
            else 
               tcpaccept=jrpui_pytcpaccept;
            if(pylib::is_none(instance->pysessionserver_.ref()))
               ssession=0;
            else 
               ssession=jrpui_pysessionserver;
            if(pylib::is_none(instance->pycloselisten_.ref()))
               lclose=0;
            else 
               lclose=jrpui_pycloselisten;
            if(pylib::is_none(instance->pycloseserver_.ref()))
               sclose=0;
            else 
               sclose=jrpui_pycloseserver;
            instance->set_p2p_server_event(tcpaccept,ssession,lclose,sclose);
            return pylib::retnone();                      
        }
        return 0;
    }
};

struct stub_JrpUI_jrpcommon:public pylib::Member_def<PyJrpUI>
{
    pylib::Objref *def(PyJrpUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
        {
            PyJrpCommon *jrpcommon=(PyJrpCommon *)instance->jrpcommon();
            return pylib::Converter<PyJrpCommon *>(jrpcommon,false);    
        }
        return 0;
    }
};

struct stub_JrpUI_new_client:public pylib::Member_def<PyJrpUI>
{
    pylib::Objref *def(PyJrpUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            net::Address *peer=args.get<net::Address *>(0);
            return pylib::Converter<event::Cell *>(instance->new_client(peer),false);
        }
        else if (args.size() == 2)
        {
            net::Address *peer=args.get<net::Address *>(0);
            net::ProxyChain *proxy=0;
            if(!args.is_none(1))
                proxy=args.get<net::ProxyChain *>(1); 
            return pylib::Converter<event::Cell *>(instance->new_client(peer,proxy),false);
        }
        return 0;
    }
};

struct stub_JrpUI_connect_search:public pylib::Member_def<PyJrpUI>
{
    pylib::Objref *def(PyJrpUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp::str fingerprint=args.get<vmp::str>(0);
            event::Cell *cell=instance->connect_search(fingerprint);
            if(cell == 0)
                return pylib::retnone();
            return pylib::Converter<event::Cell *>(cell,false);
        }
        return 0;
    }
};

struct stub_JrpUI_search_peer:public pylib::Member_def<PyJrpUI>
{
    pylib::Objref *def(PyJrpUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
            return pylib::Converter<vmp::vector<vmp::str> >(instance->search_peer());
        else if (args.size() == 1)
        {
            vmp::str input=args.get<vmp::str>(1);
            return pylib::Converter<vmp::vector<vmp::str> >(instance->search_peer(input));
        }
        return 0;
    }
};

struct stub_JrpUI_request:public pylib::Member_def<PyJrpUI>
{
    pylib::Objref *def(PyJrpUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            event::Cell *cell=args.get<event::Cell *>(0);
            json::JsonObj *jdata=args.get<json::JsonObj *>(1);
            jrp::JrpReq *req=instance->request(cell,jdata);
            return pylib::Converter<jrp::JrpReq *>(req,false);
        }
        else if(args.size() == 3)
        {
            event::Cell *cell=args.get<event::Cell *>(0);
            json::JsonObj *jdata=args.get<json::JsonObj *>(1);
            vmp::Buf *payload=0;
            if(!args.is_none(2))
                payload=args.get<vmp::Buf *>(2);
            jrp::JrpReq *req=instance->request(cell,jdata,payload);
            return pylib::Converter<jrp::JrpReq *>(req,false);
            
        }
        return 0;
     }
};

struct stub_JrpUI_request_f:public pylib::Member_def<PyJrpUI>
{
    pylib::Objref *def(PyJrpUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            vmp::str fingerprint=args.get<vmp::str>(0);
            json::JsonObj *jdata=args.get<json::JsonObj *>(1);
            jrp::JrpReq *req=instance->request_f(fingerprint,jdata);
            return pylib::Converter<jrp::JrpReq *>(req,false);
        }
        else if(args.size() == 3)
        {
            vmp::str fingerprint=args.get<vmp::str>(0);
            json::JsonObj *jdata=args.get<json::JsonObj *>(1);
            vmp::Buf *payload=0;
            if(!args.is_none(2))
                payload=args.get<vmp::Buf *>(2);
            jrp::JrpReq *req=instance->request_f(fingerprint,jdata,payload);
            return pylib::Converter<jrp::JrpReq *>(req,false);
            
        }
        return 0;
    }
};

struct stub_JrpUI_broadcast:public pylib::Member_def<PyJrpUI>
{
    pylib::Objref *def(PyJrpUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            event::Cell *cell=args.get<event::Cell *>(0);
            json::JsonObj *jdata=args.get<json::JsonObj *>(1);
            instance->broadcast(cell,jdata);
            return pylib::retnone();
        }
        else if(args.size() == 3)
        {
            event::Cell *cell=args.get<event::Cell *>(0);
            json::JsonObj *jdata=args.get<json::JsonObj *>(1);
            vmp::Buf *payload=0;
            if(!args.is_none(2))
                payload=args.get<vmp::Buf *>(2);
            instance->broadcast(cell,jdata,payload);
            return pylib::retnone();
            
        }
        return 0;  
    }
};

PyWssJrpUI::PyWssJrpUI(event::Manager *manager,crypto::Ctx_Peer_Web *ctx,vmp::str webroot,jrp::JrpCommon *jrpcommon,vmp::utils::Logger *logger,vmp::time::Time ctimeout):jrp::WssJrpUI(manager,ctx,webroot,jrpcommon,logger,ctimeout)
{
}

PyWssJrpUI::~PyWssJrpUI()
{
}

void wssjrpui_pytcpaccept(event::Cell *cell,event::Cell *child)
{
    PyWssJrpUI *wssjrpui=cell->ui<PyWssJrpUI>();
    pylib::CArgs cargs(2);
    cargs.add<event::Cell *>(cell,false);
    cargs.add<event::Cell *>(child,false);
    wssjrpui->pytcpaccept_.call(cargs);
}

void wssjrpui_pysession(event::Cell *cell)
{
    PyWssJrpUI *wssjrpui=cell->ui<PyWssJrpUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    wssjrpui->pysession_.call(cargs);
}

void wssjrpui_pycloselisten(event::Cell *cell)
{
    PyWssJrpUI *wssjrpui=cell->ui<PyWssJrpUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    wssjrpui->pycloselisten_.call(cargs);
}

void wssjrpui_pycloseserver(event::Cell *cell)
{
    PyWssJrpUI *wssjrpui=cell->ui<PyWssJrpUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    wssjrpui->pycloseserver_.call(cargs);
}

struct stub_wssjrpui:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            event::Cell *cell=args.get<event::Cell *>(0);
            return pylib::Converter<PyWssJrpUI *>(cell->ui<PyWssJrpUI>(),false);
        }
        return 0;
    }
};

struct WssJrpUI_Constructor:public pylib::Constructor<PyWssJrpUI>
{
    PyWssJrpUI *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 4)
         {
             event::Manager *manager=args.get<event::Manager *>(0);
             crypto::Ctx_Peer_Web *ctx=args.get<crypto::Ctx_Peer_Web *>(1);
             vmp::str webroot=args.get<vmp::str>(2);
             PyJrpCommon *common=args.get<PyJrpCommon *>(3);
             return new PyWssJrpUI(manager,ctx,webroot,(jrp::JrpCommon *)common);
         }
         else if(args.size() == 5)
         {
             event::Manager *manager=args.get<event::Manager *>(0);
             crypto::Ctx_Peer_Web *ctx=args.get<crypto::Ctx_Peer_Web *>(1);
             vmp::str webroot=args.get<vmp::str>(2);
             PyJrpCommon *common=args.get<PyJrpCommon *>(3);
             vmp::utils::Logger *logger=0;
             if(!args.is_none(4))
                logger=args.get<vmp::utils::Logger *>(4); 
             return new PyWssJrpUI(manager,ctx,webroot,(jrp::JrpCommon *)common,logger);
         }
         else if(args.size() == 6)
         {
             event::Manager *manager=args.get<event::Manager *>(0);
             crypto::Ctx_Peer_Web *ctx=args.get<crypto::Ctx_Peer_Web *>(1);
             vmp::str webroot=args.get<vmp::str>(2);
             PyJrpCommon *common=args.get<PyJrpCommon *>(3);
             vmp::utils::Logger *logger=0;
             if(!args.is_none(4))
                logger=args.get<vmp::utils::Logger *>(4);
             vmp::time::Time ctimeout=args.get<vmp::time::Time>(5);
             return new PyWssJrpUI(manager,ctx,webroot,(jrp::JrpCommon *)common,logger,ctimeout);
         }
         return 0;
    }
};

struct stub_WssJrpUI_set_wss_event:public pylib::Member_def<PyWssJrpUI>
{
    pylib::Objref *def(PyWssJrpUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 4)
        {
            net::EVTCBACCEPT tcpaccept;
            event::EVTCB session;
            event::EVTCB lclose;
            event::EVTCB sclose;
            
            args.get_callable(0,instance->pytcpaccept_);
            args.get_callable(1,instance->pysession_);
            args.get_callable(2,instance->pycloselisten_);
            args.get_callable(3,instance->pycloseserver_);
            
            if(pylib::is_none(instance->pytcpaccept_.ref()))
               tcpaccept=0;
            else 
               tcpaccept=wssjrpui_pytcpaccept;
            if(pylib::is_none(instance->pysession_.ref()))
               session=0;
            else 
               session=wssjrpui_pysession;
            if(pylib::is_none(instance->pycloselisten_.ref()))
               lclose=0;
            else 
               lclose=wssjrpui_pycloselisten;
            if(pylib::is_none(instance->pycloseserver_.ref()))
               sclose=0;
            else 
               sclose=wssjrpui_pycloseserver;
            instance->set_wss_event(tcpaccept,session,lclose,sclose);
            return pylib::retnone();   
        }
        return 0;
    }
};

struct stub_WssJrpUI_new_listen:public pylib::Member_def<PyWssJrpUI>
{
    pylib::Objref *def(PyWssJrpUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 4)
        {
            net::Address *local=args.get<net::Address *>(0);
            vmp_uint backlog=args.get<vmp_uint>(1);
            vmp::vector<vmp::str> hosts=args.get<vmp::vector<vmp::str> >(2);
            vmp::vector<vmp::str> origins=args.get<vmp::vector<vmp::str> >(3);
            event::Cell *cell=instance->new_listen(local,backlog,hosts,origins);
            return pylib::Converter<event::Cell *>(cell,false);
        }
        else if(args.size() == 5)
        {
            net::Address *local=args.get<net::Address *>(0);
            vmp_uint backlog=args.get<vmp_uint>(1);
            vmp::vector<vmp::str> hosts=args.get<vmp::vector<vmp::str> >(2);
            vmp::vector<vmp::str> origins=args.get<vmp::vector<vmp::str> >(3);
            vmp_bool localhost=args.get<vmp_bool>(4);
            event::Cell *cell=instance->new_listen(local,backlog,hosts,origins,localhost);
            return pylib::Converter<event::Cell *>(cell,false);
        }
        return 0;
    }
};

struct stub_WssJrpUI_jrpcommon:public pylib::Member_def<PyWssJrpUI>
{
    pylib::Objref *def(PyWssJrpUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
        {
            PyJrpCommon *jrpcommon=(PyJrpCommon *)instance->jrpcommon();
            return pylib::Converter<PyJrpCommon *>(jrpcommon,false);    
        }
        return 0;
    }
};
struct stub_WssJrpUI_connect_search:public pylib::Member_def<PyWssJrpUI>
{
    pylib::Objref *def(PyWssJrpUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp::str user=args.get<vmp::str>(0);
            event::Cell *cell=instance->connect_search(user);
            if(cell == 0)
                return pylib::retnone();
            return pylib::Converter<event::Cell *>(cell,false);
        }
        return 0;
    }
};

struct stub_WssJrpUI_broadcast:public pylib::Member_def<PyWssJrpUI>
{
    pylib::Objref *def(PyWssJrpUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            event::Cell *cell=args.get<event::Cell *>(0);
            json::JsonObj *jdata=args.get<json::JsonObj *>(1);
            instance->broadcast(cell,jdata);
            return pylib::retnone();
        }
        else if(args.size() == 3)
        {
            event::Cell *cell=args.get<event::Cell *>(0);
            json::JsonObj *jdata=args.get<json::JsonObj *>(1);
            vmp::Buf *payload=0;
            if(!args.is_none(2))
                payload=args.get<vmp::Buf *>(2);
            instance->broadcast(cell,jdata,payload);
            return pylib::retnone();
        }
        return 0;  
    }
};

VAMPIRIA_PYLIB_INIT(vmp_jrp_);

void jrp_init(pylib::Module module)
{
    module.add_const<vmp::str>("protoname_",jrp::protoname_);
    
    module.add_const<vmp_int>("status_ok",jrp::status_ok);
    module.add_const<vmp_int>("status_err",jrp::status_err);
    module.add_const<vmp_int>("status_malformed_msg",jrp::status_malformed_msg);
    module.add_const<vmp_int>("status_undef_datatype",jrp::status_undef_datatype);
    module.add_const<vmp_int>("status_accessdenied",jrp::status_accessdenied);
    module.add_const<vmp_int>("status_duplexsession",jrp::status_duplexsession);
    module.add_const<vmp_int>("status_protocolbad",jrp::status_protocolbad);
    module.add_const<vmp_int>("status_closeconnection",jrp::status_closeconnection);
    module.add_const<vmp_int>("status_timeout",jrp::status_timeout);
    module.add_const<vmp_int>("status_killed",jrp::status_killed);
    module.add_const<vmp_int>("status_input_bad",jrp::status_input_bad);
    module.add_const<vmp_int>("status_push_bad",jrp::status_push_bad);
    module.add_const<vmp_int>("status_input_notmanaged",jrp::status_input_notmanaged);
    module.add_const<vmp_int>("status_rid_duplex",jrp::status_rid_duplex);
    module.add_const<vmp_int>("status_resource_busy",jrp::status_resource_busy);
    module.add_const<vmp_int>("status_resource_accessdenied",jrp::status_resource_accessdenied);
    module.add_const<vmp_int>("status_kill_notcomplete",jrp::status_kill_notcomplete);
    module.add_const<vmp_int>("status_forward_denied",jrp::status_forward_denied);
    module.add_const<vmp_int>("status_request_overflow",jrp::status_request_overflow);
    module.add_const<vmp_int>("status_resource_notfound",jrp::status_resource_notfound);
    module.add_const<vmp_int>("status_request_timeout",jrp::status_request_timeout);
    module.add_const<vmp_int>("status_managed_timeout",jrp::status_managed_timeout);
    module.add_const<vmp_int>("status_accesspeerdenied",jrp::status_accesspeerdenied);
    module.add_const<vmp_int>("status_internal",jrp::status_internal);
    module.add_const<vmp_int>("status_resource_killed",jrp::status_resource_killed);
    module.add_const<vmp_index>("min_permits",jrp::min_permits);
    module.add_const<vmp_index>("max_permits",jrp::max_permits);
    
    module.def_("msg_status",jrp::msg_status);
    
    //Wrapper cell->ui()
    module.def_with_stub("jrpui",stub_jrpui());
    pylib::Class<PyJrpUI> jrpui=module.class_with_constructor<PyJrpUI>("JrpUI",JrpUI_Constructor());
    jrpui.def_with_stub("set_p2p_client_event",stub_JrpUI_set_p2p_client_event());
    jrpui.def_with_stub("set_p2p_server_event",stub_JrpUI_set_p2p_server_event());
    jrpui.def_("set_key_update",&PyJrpUI::set_key_update);
    jrpui.def_with_stub("new_client",stub_JrpUI_new_client());
    jrpui.def_("new_listen",&PyJrpUI::new_listen,false);
    jrpui.def_("localaddr",&PyJrpUI::localaddr,false);
    jrpui.def_("peeraddr",&PyJrpUI::peeraddr,false);
    jrpui.def_("proxychain",&PyJrpUI::proxychain,false);
    jrpui.def_("connection_type",&PyJrpUI::connection_type);
    jrpui.def_("connection_strtype",&PyJrpUI::connection_strtype);
    jrpui.def_with_stub("jrpcommon",stub_JrpUI_jrpcommon());
    jrpui.def_("ctx",&PyJrpUI::ctx,false);
    jrpui.def_("logger",&PyJrpUI::logger,false);
    jrpui.def_with_stub("connect_search",stub_JrpUI_connect_search());
    jrpui.def_("connect_list",&PyJrpUI::connect_list);
    jrpui.def_("permits",&PyJrpUI::permits);
    jrpui.def_("get_peer_x509",&PyJrpUI::get_peer_x509);
    jrpui.def_("peer_fingerprint",&PyJrpUI::peer_fingerprint);
    jrpui.def_("peer_subject",&PyJrpUI::peer_subject);
    jrpui.def_("peer_permits",&PyJrpUI::peer_permits);
    jrpui.def_("peer_permits_f",&PyJrpUI::peer_permits_f);
    jrpui.def_("peer_nodetype",&PyJrpUI::peer_nodetype);
    jrpui.def_("peer_subject_f",&PyJrpUI::peer_subject_f);
    jrpui.def_("peer_permits_f",&PyJrpUI::peer_permits_f);
    jrpui.def_("peer_nodetype_f",&PyJrpUI::peer_nodetype_f);
    jrpui.def_with_stub("search_peer",stub_JrpUI_search_peer());
    jrpui.def_("search_peer_p",&PyJrpUI::search_peer_p);
    jrpui.def_("search_peer_o",&PyJrpUI::search_peer_o);
    jrpui.def_("all_input",&PyJrpUI::all_input);
    jrpui.def_("all_input_f",&PyJrpUI::all_input_f);
    jrpui.def_("search_input_push",&PyJrpUI::search_input_push);
    jrpui.def_("search_input_push_f",&PyJrpUI::search_input_push_f);
    jrpui.def_("search_input_response",&PyJrpUI::search_input_response);
    jrpui.def_("search_input_response_f",&PyJrpUI::search_input_response_f);
    jrpui.def_("search_push",&PyJrpUI::search_push);
    jrpui.def_("search_push_f",&PyJrpUI::search_push_f);
    jrpui.def_("search_response",&PyJrpUI::search_response);
    jrpui.def_("search_response_f",&PyJrpUI::search_response_f);
    jrpui.def_("broadcastdata_peer",&PyJrpUI::broadcastdata_peer);
    jrpui.def_("broadcastdata_peer_f",&PyJrpUI::broadcastdata_peer_f);
    jrpui.def_with_stub("request",stub_JrpUI_request());
    jrpui.def_with_stub("request_f",stub_JrpUI_request_f());
    jrpui.def_with_stub("broadcast",stub_JrpUI_broadcast());
    
    //Wrapper cell->ui()
    module.def_with_stub("wssjrpui",stub_wssjrpui());
    pylib::Class<PyWssJrpUI> wssjrpui=module.class_with_constructor<PyWssJrpUI>("WssJrpUI",WssJrpUI_Constructor());
    wssjrpui.def_("set_http",&PyWssJrpUI::set_http);
    wssjrpui.def_with_stub("set_wss_event",stub_WssJrpUI_set_wss_event());
    wssjrpui.def_with_stub("new_listen",stub_WssJrpUI_new_listen());
    wssjrpui.def_("localaddr",&PyWssJrpUI::localaddr,false);
    wssjrpui.def_("peeraddr",&PyWssJrpUI::peeraddr,false);
    wssjrpui.def_("connection_type",&PyWssJrpUI::connection_type);
    wssjrpui.def_("connection_strtype",&PyWssJrpUI::connection_strtype);
    wssjrpui.def_with_stub("jrpcommon",stub_WssJrpUI_jrpcommon());
    wssjrpui.def_("ctx",&PyWssJrpUI::ctx,false);
    wssjrpui.def_("logger",&PyWssJrpUI::logger,false);
    wssjrpui.def_with_stub("connect_search",stub_WssJrpUI_connect_search());
    wssjrpui.def_("connect_list",&PyWssJrpUI::connect_list);
    wssjrpui.def_("user",&PyWssJrpUI::user);
    wssjrpui.def_("permits",&PyWssJrpUI::permits);
    wssjrpui.def_("permits_u",&PyWssJrpUI::permits_u);
    wssjrpui.def_with_stub("broadcast",stub_WssJrpUI_broadcast());
}

void vampiria_pylib_init_module(pylib::Module init_module)
{
    jrp_eventjrp(init_module);
    jrp_jrpreq(init_module);
    jrp_init(init_module);
    
    pylib::Module misc=init_module.add_submodule("misc");
    jrp_misc_status(misc);
    jrp_misc_utils(misc);
    jrp_misc_onion(misc);
}

 
 
