/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 25/10/2024
 */

#include "event_.h"

class PyInputUI:public event::InputUI
{
   public:
        PyInputUI(event::Manager *manager);
        ~PyInputUI();

        pylib::PyCall pyievent_;
        pylib::PyCall pycevent_;
};

PyInputUI::PyInputUI(event::Manager *manager):event::InputUI(manager)
{
}

PyInputUI::~PyInputUI()
{
}

struct stub_inputui:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            event::Cell *cell=args.get<event::Cell *>(0);
            return pylib::Converter<PyInputUI *>(cell->ui<PyInputUI>(),false);

        }
        return 0;
    }
};

struct InputUI_Constructor:public pylib::Constructor<PyInputUI>
{
    PyInputUI *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 1)
         {
              event::Manager *manager=args.get<event::Manager *>(0);
              return new PyInputUI(manager);
         }
         return 0;
    }
};

void input_pyievent(event::Cell *cell,vmp::str idata)
{
    PyInputUI *inputui=cell->ui<PyInputUI>();
    pylib::CArgs cargs(2);
    cargs.add<event::Cell *>(cell,false);
    cargs.add<vmp::str>(idata);
    inputui->pyievent_.call(cargs);
}

void input_pycevent(event::Cell *cell)
{
    PyInputUI *inputui=cell->ui<PyInputUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    inputui->pycevent_.call(cargs);
}

struct stub_InputUI_set_event:public pylib::Member_def<PyInputUI>
{
    pylib::Objref *def(PyInputUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            event::EVTCBSTR ievent;
            event::EVTCB cevent;
            
            args.get_callable(0,instance->pyievent_);
            args.get_callable(1,instance->pycevent_);
            
            if(pylib::is_none(instance->pyievent_.ref()))
               ievent=0;
            else 
               ievent=input_pyievent;
            if(pylib::is_none(instance->pycevent_.ref()))
               cevent=0;
            else 
               cevent=input_pycevent;
            instance->set_event(ievent,cevent);
            return pylib::retnone();                      
        }
        return 0;
    }
};


void event_init_inputui(pylib::Module module)
{
    //Wrapper cell->ui()
    module.def_with_stub("inputui",stub_inputui());
    //event0/ui/inputui.h
    pylib::Class<PyInputUI> inputui=module.class_with_constructor<PyInputUI>("InputUI",InputUI_Constructor());
    inputui.def_with_stub("set_event",stub_InputUI_set_event());
    inputui.def_("input",&PyInputUI::input,false);
    inputui.def_("isenable",&PyInputUI::input);
    inputui.def_("enable",&PyInputUI::input);
    inputui.def_("disable",&PyInputUI::input);
}

