/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 21/01/2025
 */
 
#include "crypto_.h"

void crypto_ssl(pylib::Module module)
{
    pylib::Class<crypto::Ssl> ssl=module.class_<crypto::Ssl>("Ssl");
    ssl.def_("reset",&crypto::Ssl::reset);
    ssl.def_("set",&crypto::Ssl::set);
    ssl.def_("get_socket",&crypto::Ssl::get_socket);
    ssl.def_("get_errno",&crypto::Ssl::get_errno);
    ssl.def_("ctx",&crypto::Ssl::ctx,false);
    ssl.def_("get_local_x509",&crypto::Ssl::get_local_x509);
    ssl.def_("get_peer_x509",&crypto::Ssl::get_peer_x509);
    ssl.def_("send",&crypto::Ssl::send);
    ssl.def_("recv",&crypto::Ssl::recv);
    ssl.def_("key_update",&crypto::Ssl::key_update);
    ssl.def_("connect",&crypto::Ssl::connect);
    ssl.def_("accept",&crypto::Ssl::accept);
    ssl.def_("shutdown",&crypto::Ssl::shutdown);
}

