/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 07/06/2025
 */
 
#include "pylib.h"
#include "crypto.h"

#ifndef VAMPIRIA_PY_CRYPTO_H

#define VAMPIRIA_PY_CRYPTO_H 1

//!Python wrapper of the c++ namespace vampiria::crypto in vmp_crypto.(see c++ doc)
/*!
    Function c++ crypto.h:<BR>init(),end()
*/
/*!
    Wrapper Cell->ui() for ssl in sslui(cell)<BR>
    @return user interface ssl ui for cell.(The cell must be built with the SslUI user interface)
*/
/*!
    SslUI class in openssl{version}/openssl.h(pkg):<BR>Constructor SslUI(manager,ctx,ctimeout=default value)<BR>
    SslUI member function list:<BR>set_event_client(),set_event_server(),set_time_keyupdate(),new_client(),new_listen(),send(),
                                   key_update(),localaddr(),peeraddr(),proxyinfo(),connection_type(),
                                   connection_strtype(),get_local_x509(),get_peer_x509()
                                   
*/
/*!
    Function c++ crypto/eventssl.h:<BR>ssl_shutdown()
*/
void crypto_init(pylib::Module module);

//!Python wrapper of the c++ namespace vampiria::crypto in vmp_crypto.(see c++ doc)
/*!
    Function c++ crypto/openssl/hash.h:<BR>
    md5(),md5_bin(),sha1(),sha1_bin(),sha224(),sha224_bin(),
    sha256(),sha256_bin(),sha384(),sha384_bin(),sha512(),sha512_bin()
*/
void crypto_hash(pylib::Module module);

//!Python wrapper of the c++ class vampiria::crypto::PKey in vmp_crypto.PKey(see c++ doc)
/*!
    PKey class in crypto/pkey.h(pkg):<BR>Constructor PKey()<BR>
    PKey member function list:<BR>reset(),keytype(),key_print(),type_str()
*/
void crypto_pkey(pylib::Module module);

//!Python wrapper of the c++ class vampiria::crypto::X509_Wrap in vmp_crypto.X509_Wrap(see c++ doc)
/*!
    X509_Wrap class in crypto/x509.h(pkg):<BR>Constructor X509_Wrap()<BR>
    X509_Wrap member function list:<BR>
    reset(),set_from_file(),parent(),version(),serial(),signature_info(),
    issuer(),validity_before(),validity_after(),subject(),pubkey(),
    id_issuer(),id_subject(),extensions(),signature_data(),fingerprint_sha1(),
    fingerprint_sha256(),address(),verify()
*/
/*!
    Function c++ crypto/x509.h:<BR>
    X509_address_tourl(),X509_address_fromurl(),X509_isaddress()
*/
void crypto_x509(pylib::Module module);

//!Python wrapper of the c++ class vampiria::crypto::Ssl in vmp_crypto.Ssl(see c++ doc)
/*!
    Ssl class in crypto/ssl.h(pkg):<BR>Constructor Ssl()<BR>
    Ssl member function list:<BR>
    reset(),set(),get_socket(),get_errno(),ctx(),get_local_x509(),get_peer_x509(),
    send(),recv(),key_update(),connect(),accept(),shutdown()
*/
    
void crypto_ssl(pylib::Module module);

//!Python wrapper of the c++ class vampiria::crypto::SslBio in vmp_crypto.SslBio(see c++ doc)
/*!
    SslBio class in crypto/sslbio.h(pkg):<BR>Constructor SslBio() or SslBio(ctx)<BR>
    SslBio member function list:<BR>
    reset(),set(),get_errno(),get_error(),ctx(),get_local_x509(),get_peer_x509(),
    connect(),accept(),is_client(),is_server(),recv(),send(),key_update(),
    shutdown(),close()
*/
    
void crypto_sslbio(pylib::Module module);

//!Python wrapper of the c++ class vampiria::crypto::{Context class} in vmp_crypto.{Context Class}(see c++ doc)
/*!
    Context class in crypto/ctx.h(pkg):<BR>No Constructor<BR>
    Ctx function list:<BR>get_x509()
    
*/
/*!
    Ctx_Base_Tls_Client class in crypto/ctx/base.h:<BR>Constructor Ctx_Base_Tls_Client()
    Ctx_Base_Tls_Client function list:<BR>get()
*/
/*!
    Ctx_Base_Tls_Server class in crypto/ctx/base.h(pkg):<BR>Constructor Ctx_Base_Tls_Server(pkey,x509)
    Ctx_Base_Tls_Server function list:<BR>get()
*/
/*!
    Ctx_Https_Tls class in crypto/ctx/https.h(pkg):<BR>Constructor Ctx_Https_Tls(dircert,subject,days=default)
    Ctx_Https_Tls function list:<BR>get()
*/

/*!
    Ctx_Peer_Acl class in crypto/ctx/peer.h(pkg):<BR>Constructor Ctx_Peer_Acl()
    Ctx_Peer_Acl function list:<BR>fingerprint(),subject(),permits()
*/
/*!
    Ctx_Peer class in crypto/ctx/peer.h(pkg):<BR>Constructor Ctx_Peer(dircert,defp,subject,days=365000)<BR>
    Ctx_Peer function list:<BR>get(),get_x509(),subject(),
    fingerprint(),defp(),add_acl_peer(),del_acl_peer(),
    fingerprints_acl_peer(),gpeer_fingerprintet_acl_subject(),
    verify_acl_peer(),verify_peer(),print_acl()
*/
/*!
    Ctx_Peer_Web class in crypto/ctx/peer.h(pkg):<BR>Constructor Ctx_Peer_Web(ctx_peer)<BR>
    Ctx_Peer_Web function list:<BR>get(),peer(),add_acl_user(),change_password(),
                                   change_permits(),reset_acl_users(),del_acl_user(),
                                   list_acl_users(),get_md5_password(),get_only_localhost(),
                                   get_permits(),verify_acl_user(),print_acl_users()
*/
void crypto_ctx(pylib::Module module);

#endif


