/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 30/05/2025
 */

#include "vmp_.h"

struct stub_except_s:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        vmp::str arg0;
        if(args.size() == 1)
        {
            arg0=args.get<vmp::str>(0);
            try
            {
                vmp::except_s(arg0);
            }
            catch(vmp::exception &x)
            {
                vmp::except_runtime(x.what());
            } 
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_init:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        vmp::str arg0;
        vmp_bool arg1=false;
        if(args.size() == 1)
        {
            arg0=args.get<vmp::str>(0);     
        }
        else if(args.size() == 2)
        {
            arg0=args.get<vmp::str>(0);
            arg1=args.get<vmp_bool>(1);
        }
        else
            return 0;
        vmp::init(arg0,arg1);
        return pylib::retnone();
    }
};

struct stub_rand_wrap:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
            return pylib::Converter<vmp_uint>(vmp::rand_wrap());
        else if(args.size() == 1)
        {
            vmp_uint hop=args.get<vmp_uint>(0);
            return pylib::Converter<vmp_uint>(vmp::rand_wrap(hop));
        }
        return 0; 
    }
};
static vmp::Table<vmp_int,pylib::PyCall *> sigcall_;

void signal_handler(vmp_int sig)
{
    pylib::GilState gstate=pylib::gil_ensure();
    pylib::PyCall *ret;
    if(sigcall_.search(sig,&ret))
    {
        pylib::CArgs args(1);
        args.add<vmp_int>(sig);
        pylib::PyObj res=ret->call(args);
        res.reset();
    }
    pylib::gil_release(gstate);
}

struct stub_signal_wrap:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            vmp::vector<vmp::str> arg0=args.get<vmp::vector<vmp::str> >(0);
            pylib::PyCall arg1;
            args.get_callable(1,arg1);
            if(arg0.size() != 0)
            {
                vmp::signal_wrap(arg0,signal_handler);
                for(vmp_index i=0;i<arg0.size();i++)
                {
                    pylib::PyCall *tmp=new pylib::PyCall();
                    (*tmp)=arg1;
                    if(sigcall_.update(vmp::signum(arg0[i]),&tmp))
                        delete tmp;
                }
            }
            return pylib::retnone();
        }
        return 0; 
    }
};

void vmp_init(pylib::Module module)
{
    //vmp/basetypes.h
    module.add_const<vmp_int>("INTMIN",vmp::INTMIN);
    module.add_const<vmp_int>("INTMAX",vmp::INTMAX);
    module.add_const<vmp_int16>("INT16MIN",vmp::INT16MIN);
    module.add_const<vmp_int16>("INT16MAX",vmp::INT16MAX);
    module.add_const<vmp_uint>("UINTMIN",vmp::UINTMIN);
    module.add_const<vmp_uint>("UINTMAX",vmp::UINTMAX);
    module.add_const<vmp_uint16>("UINT16MIN",vmp::UINT16MIN);
    module.add_const<vmp_uint16>("UINT16MAX",vmp::UINT16MAX);
    module.add_const<vmp_char>("CHARMIN",vmp::CHARMIN);
    module.add_const<vmp_char>("CHARMAX",vmp::CHARMAX);
    module.add_const<vmp_uchar>("UCHARMIN",vmp::UCHARMIN);
    module.add_const<vmp_uchar>("UCHARMAX",vmp::UCHARMAX);
    module.add_const<vmp_uint>("RANDMAX",vmp::RANDMAX);
    module.add_const<vmp_int64>("INT64MIN",vmp::INT64MIN);
    module.add_const<vmp_int64>("INT64MAX",vmp::INT64MAX);
    module.add_const<vmp_uint64>("UINT64MIN",vmp::UINT64MIN);
    module.add_const<vmp_uint64>("UINT64MAX",vmp::UINT64MAX);
    
    //vmp/error.h
    module.def_with_stub("except_s",stub_except_s());
    module.def_("get_errno",vmp::get_errno);
    module.def_("value_errno",vmp::value_errno);

    //vmp/io.h
    module.def_with_stub("init",stub_init());
    module.def_("is_debug_mode",vmp::is_debug_mode);
    module.def_("id",vmp::id);
    module.def_("io_forced_unlock",vmp::io_forced_unlock);
    module.def_("io_recovery_lock",vmp::io_recovery_lock);
    module.def_("debug",vmp::debug_s);
    module.def_("info",vmp::info_s);
    module.def_("warning",vmp::warning_s);
    module.def_("error",vmp::error_s);
    module.def_("error_raw",vmp::error_raw_s);
    module.def_("output",vmp::output_s);
    module.def_("output_raw",vmp::output_raw_s);
    module.def_("output_file",vmp::output_file_s);
    module.def_("output_file_lines",vmp::output_file_lines);
    module.def_("input",vmp::input);
    module.def_("input_file",vmp::input_file);
    module.def_("input_file_s",vmp::input_file_s);
    module.def_("input_part_file",vmp::input_part_file);
    module.def_("exit_ok",vmp::exit_ok);
    module.def_("exit_failure",vmp::exit_failure_s);
    module.def_("copy_file",vmp::copy_file);
    module.def_("move_file",vmp::move_file);

    //vmp/lib/process.h
    module.def_("system_wrap",vmp::system_wrap);
    module.def_("getpid_wrap",vmp::getpid_wrap);
    module.def_("getuid_wrap",vmp::getuid_wrap);
    module.def_("geteuid_wrap",vmp::geteuid_wrap);
    module.def_("getgid_wrap",vmp::getgid_wrap);
    module.def_("getegid_wrap",vmp::getegid_wrap);
    module.def_("getuid_user",vmp::getuid_user);
    module.def_("getgid_user",vmp::getgid_user);
    module.def_("setuid_wrap",vmp::setuid_wrap);
    module.def_("setgid_wrap",vmp::setgid_wrap);
    module.def_("setuid_user",vmp::setuid_user);
    module.def_("setgid_user",vmp::setgid_user);
    module.def_("pause_wrap",vmp::pause_wrap);
    module.def_("kill_wrap",vmp::kill_wrap);
    
    //vmp/lib/fd.h
    module.def_("dup2_wrap",vmp::dup2_wrap);
    module.def_("fd_noblock",vmp::fd_noblock);
    module.def_("fd_block",vmp::fd_block);
    module.def_("fd_fsync",vmp::fd_fsync);
    
    //vmp/lib/types.h
    module.def_("srand_wrap",vmp::srand_wrap);
    module.def_with_stub("rand_wrap",stub_rand_wrap());
    
    //vmp/lib/dev.h
    pylib::Class<vmp::Dev_t_wrap> dev=module.class_<vmp::Dev_t_wrap>("Dev_t_wrap");
    dev.def_("set_values",&vmp::Dev_t_wrap::set_values);
    dev.def_("get_major",&vmp::Dev_t_wrap::get_major);
    dev.def_("get_minor",&vmp::Dev_t_wrap::get_minor);
    
    //vmp/signal.h
    module.def_("signum",vmp::signum);
    module.def_("sigstr",vmp::sigstr);
    module.def_("sigcmp",vmp::sigcmp);
    module.def_with_stub("signal_wrap",stub_signal_wrap());
    
    pylib::Module errnomod=module.add_submodule("errno");
    errnomod.add_const<vmp_int>("EPERM",EPERM);
    errnomod.add_const<vmp_int>("ENOENT",ENOENT);
    errnomod.add_const<vmp_int>("ESRCH",ESRCH);
    errnomod.add_const<vmp_int>("EINTR",EINTR);
    errnomod.add_const<vmp_int>("EIO",EIO);
    errnomod.add_const<vmp_int>("ENXIO",ENXIO);
    errnomod.add_const<vmp_int>("E2BIG",E2BIG);
    errnomod.add_const<vmp_int>("ENOEXEC",ENOEXEC);
    errnomod.add_const<vmp_int>("EBADF",EBADF);
    errnomod.add_const<vmp_int>("ECHILD",ECHILD);
    errnomod.add_const<vmp_int>("EAGAIN ",EAGAIN );
    errnomod.add_const<vmp_int>("ENOMEM",ENOMEM);
    errnomod.add_const<vmp_int>("EACCES",EACCES);
    errnomod.add_const<vmp_int>("EFAULT",EFAULT);
    errnomod.add_const<vmp_int>("ENOTBLK",ENOTBLK);
    errnomod.add_const<vmp_int>("EBUSY",EBUSY);
    errnomod.add_const<vmp_int>("EEXIST",EEXIST);
    errnomod.add_const<vmp_int>("EXDEV",EXDEV);
    errnomod.add_const<vmp_int>("ENODEV",ENODEV);
    errnomod.add_const<vmp_int>("ENOTDIR",ENOTDIR);
    errnomod.add_const<vmp_int>("EISDIR",EISDIR);
    errnomod.add_const<vmp_int>("EINVAL",EINVAL);
    errnomod.add_const<vmp_int>("ENFILE",ENFILE);
    errnomod.add_const<vmp_int>("EMFILE",EMFILE);
    errnomod.add_const<vmp_int>("ENOTTY",ENOTTY);
    errnomod.add_const<vmp_int>("ETXTBSY",ETXTBSY);
    errnomod.add_const<vmp_int>("EFBIG",EFBIG);
    errnomod.add_const<vmp_int>("ENOSPC",ENOSPC);
    errnomod.add_const<vmp_int>("ESPIPE",ESPIPE);
    errnomod.add_const<vmp_int>("EROFS",EROFS);
    errnomod.add_const<vmp_int>("EMLINK",EMLINK);
    errnomod.add_const<vmp_int>("EPIPE",EPIPE);
    errnomod.add_const<vmp_int>("EDOM",EDOM);
    errnomod.add_const<vmp_int>("ERANGE",ERANGE);
    errnomod.add_const<vmp_int>("EDEADLK",EDEADLK);
    errnomod.add_const<vmp_int>("ENAMETOOLONG",ENAMETOOLONG);
    errnomod.add_const<vmp_int>("ENOLCK",ENOLCK);
    errnomod.add_const<vmp_int>("ENOSYS",ENOSYS);
    errnomod.add_const<vmp_int>("ENOTEMPTY",ENOTEMPTY);
    errnomod.add_const<vmp_int>("ELOOP",ELOOP);
    errnomod.add_const<vmp_int>("ENOMSG",ENOMSG);
    errnomod.add_const<vmp_int>("EIDRM",EIDRM);
    errnomod.add_const<vmp_int>("ECHRNG",ECHRNG);
    errnomod.add_const<vmp_int>("EL2NSYNC",EL2NSYNC);
    errnomod.add_const<vmp_int>("EL3HLT",EL3HLT);
    errnomod.add_const<vmp_int>("EL3RST",EL3RST);
    errnomod.add_const<vmp_int>("ELNRNG",ELNRNG);
    errnomod.add_const<vmp_int>("EUNATCH",EUNATCH);
    errnomod.add_const<vmp_int>("ENOCSI",ENOCSI);
    errnomod.add_const<vmp_int>("EL2HLT",EL2HLT);
    errnomod.add_const<vmp_int>("EBADE",EBADE);
    errnomod.add_const<vmp_int>("EBADR",EBADR);
    errnomod.add_const<vmp_int>("EXFULL",EXFULL);
    errnomod.add_const<vmp_int>("ENOANO",ENOANO);
    errnomod.add_const<vmp_int>("EBADRQC",EBADRQC);
    errnomod.add_const<vmp_int>("EBADSLT",EBADSLT);
    errnomod.add_const<vmp_int>("EBFONT",EBFONT);
    errnomod.add_const<vmp_int>("ENOSTR",ENOSTR);
    errnomod.add_const<vmp_int>("ENODATA",ENODATA);
    errnomod.add_const<vmp_int>("ETIME",ETIME);
    errnomod.add_const<vmp_int>("ENOSR",ENOSR);
    errnomod.add_const<vmp_int>("ENONET",ENONET);
    errnomod.add_const<vmp_int>("ENOPKG",ENOPKG);
    errnomod.add_const<vmp_int>("EREMOTE",EREMOTE);
    errnomod.add_const<vmp_int>("ENOLINK",ENOLINK);
    errnomod.add_const<vmp_int>("EADV",EADV);
    errnomod.add_const<vmp_int>("ESRMNT",ESRMNT);
    errnomod.add_const<vmp_int>("ECOMM",ECOMM);
    errnomod.add_const<vmp_int>("EPROTO",EPROTO);
    errnomod.add_const<vmp_int>("EMULTIHOP",EMULTIHOP);
    errnomod.add_const<vmp_int>("EDOTDOT",EDOTDOT);
    errnomod.add_const<vmp_int>("EBADMSG",EBADMSG);
    errnomod.add_const<vmp_int>("EOVERFLOW",EOVERFLOW);
    errnomod.add_const<vmp_int>("ENOTUNIQ",ENOTUNIQ);
    errnomod.add_const<vmp_int>("EBADFD",EBADFD);
    errnomod.add_const<vmp_int>("EREMCHG ",EREMCHG );
    errnomod.add_const<vmp_int>("ELIBACC",ELIBACC);
    errnomod.add_const<vmp_int>("ELIBBAD",ELIBBAD);
    errnomod.add_const<vmp_int>("ELIBSCN",ELIBSCN);
    errnomod.add_const<vmp_int>("ELIBMAX",ELIBMAX);
    errnomod.add_const<vmp_int>("ELIBEXEC",ELIBEXEC);
    errnomod.add_const<vmp_int>("EILSEQ",EILSEQ);
    errnomod.add_const<vmp_int>("ERESTART",ERESTART);
    errnomod.add_const<vmp_int>("ESTRPIPE",ESTRPIPE);
    errnomod.add_const<vmp_int>("EUSERS",EUSERS);
    errnomod.add_const<vmp_int>("ENOTSOCK",ENOTSOCK);
    errnomod.add_const<vmp_int>("EDESTADDRREQ",EDESTADDRREQ);
    errnomod.add_const<vmp_int>("EMSGSIZE",EMSGSIZE);
    errnomod.add_const<vmp_int>("EPROTOTYPE",EPROTOTYPE);
    errnomod.add_const<vmp_int>("ENOPROTOOPT",ENOPROTOOPT);
    errnomod.add_const<vmp_int>("EPROTONOSUPPORT",EPROTONOSUPPORT);
    errnomod.add_const<vmp_int>("ESOCKTNOSUPPORT",ESOCKTNOSUPPORT);
    errnomod.add_const<vmp_int>("EOPNOTSUPP",EOPNOTSUPP);
    errnomod.add_const<vmp_int>("EPFNOSUPPORT",EPFNOSUPPORT);
    errnomod.add_const<vmp_int>("EAFNOSUPPORT",EAFNOSUPPORT);
    errnomod.add_const<vmp_int>("EADDRINUSE",EADDRINUSE);
    errnomod.add_const<vmp_int>("EADDRNOTAVAIL",EADDRNOTAVAIL);
    errnomod.add_const<vmp_int>("ENETDOWN",ENETDOWN);
    errnomod.add_const<vmp_int>("ENETUNREACH",ENETUNREACH);
    errnomod.add_const<vmp_int>("ENETRESET",ENETRESET);
    errnomod.add_const<vmp_int>("ECONNABORTED",ECONNABORTED);
    errnomod.add_const<vmp_int>("ECONNRESET",ECONNRESET);
    errnomod.add_const<vmp_int>("ENOBUFS",ENOBUFS);
    errnomod.add_const<vmp_int>("EISCONN",EISCONN);
    errnomod.add_const<vmp_int>("ENOTCONN",ENOTCONN);
    errnomod.add_const<vmp_int>("ESHUTDOWN",ESHUTDOWN);
    errnomod.add_const<vmp_int>("ETOOMANYREFS",ETOOMANYREFS);
    errnomod.add_const<vmp_int>("ETIMEDOUT",ETIMEDOUT);
    errnomod.add_const<vmp_int>("ECONNREFUSED",ECONNREFUSED);
    errnomod.add_const<vmp_int>("EHOSTDOWN",EHOSTDOWN);
    errnomod.add_const<vmp_int>("EHOSTUNREACH",EHOSTUNREACH);
    errnomod.add_const<vmp_int>("EALREADY",EALREADY);
    errnomod.add_const<vmp_int>("EINPROGRESS",EINPROGRESS);
    errnomod.add_const<vmp_int>("ESTALE",ESTALE);
    errnomod.add_const<vmp_int>("EUCLEAN",EUCLEAN);
    errnomod.add_const<vmp_int>("ENOTNAM",ENOTNAM);
    errnomod.add_const<vmp_int>("ENAVAIL",ENAVAIL);
    errnomod.add_const<vmp_int>("EISNAM",EISNAM);
    errnomod.add_const<vmp_int>("EREMOTEIO",EREMOTEIO);
    errnomod.add_const<vmp_int>("EDQUOT",EDQUOT);
    errnomod.add_const<vmp_int>("ENOMEDIUM",ENOMEDIUM);
    errnomod.add_const<vmp_int>("EMEDIUMTYPE",EMEDIUMTYPE);
    errnomod.add_const<vmp_int>("ECANCELED",ECANCELED);
    errnomod.add_const<vmp_int>("ENOKEY",ENOKEY);
    errnomod.add_const<vmp_int>("EKEYEXPIRED",EKEYEXPIRED);
    errnomod.add_const<vmp_int>("EKEYREVOKED",EKEYREVOKED);
    errnomod.add_const<vmp_int>("EKEYREJECTED",EKEYREJECTED);
    errnomod.add_const<vmp_int>("EOWNERDEAD",EOWNERDEAD);
    errnomod.add_const<vmp_int>("ENOTRECOVERABLE",ENOTRECOVERABLE);
    
    module.def_("strerror_wrap",vmp::strerror_wrap);
}

VAMPIRIA_PYLIB_INIT(vmp_);

void vampiria_pylib_init_module(pylib::Module init_module)
{
   vmp_init(init_module);
   vmp_init_env(init_module);
   vmp_init_buf(init_module);
   vmp_init_fs(init_module);
   vmp_init_thread(init_module);
   vmp_init_time(init_module);
   vmp_init_unicode(init_module);
   vmp_init_utils(init_module);
   vmp_init_pairlist(init_module);
}

