/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 28/05/2025
 */

#include "vmp_.h"

struct stub_buf_index:public pylib::Member_def<vmp::Buf>
{
    pylib::Objref *def(vmp::Buf *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
            instance->index();
        else if(args.size() == 1)
        {
            vmp_index i=args.get<vmp_index>(0);
            instance->index(i);
        }
        else
            return 0;
        return pylib::retnone();
    }
};

struct stub_buf_write_file:public pylib::Member_def<vmp::Buf>
{
    pylib::Objref *def(vmp::Buf *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp::str pathname=args.get<vmp::str>(0);
            return pylib::Converter<vmp_size>(instance->write_file(pathname));
        }
        else if(args.size() == 2)
        {
            vmp::str pathname=args.get<vmp::str>(0);
            vmp_index pos=args.get<vmp_index>(1);
            return pylib::Converter<vmp_size>(instance->write_file(pathname,pos));
        }
        else if(args.size() == 3)
        {
            vmp::str pathname=args.get<vmp::str>(0);
            vmp_index pos=args.get<vmp_index>(1);
            vmp_size maxlen=args.get<vmp_size>(2);
            return pylib::Converter<vmp_size>(instance->write_file(pathname,pos,maxlen));
        }
        return 0;
    }
};
void vmp_init_buf(pylib::Module module)
{
    //vmp/buf.h
    module.add_const<vmp_size>("BUFSIZEMAX",vmp::BUFSIZEMAX);
    pylib::Class<vmp::Buf> buf=module.class_<vmp::Buf>("Buf");
    buf.def_("newsize",&vmp::Buf::newsize);
    buf.def_("size",&vmp::Buf::size);
    buf.def_("size_reading",&vmp::Buf::size_reading);
    buf.def_with_stub("index",stub_buf_index());
    buf.def_("get_index",&vmp::Buf::get_index);
    buf.def_("eob",&vmp::Buf::eob);
    buf.def_("reset",&vmp::Buf::reset);
    buf.def_("write_byte",&vmp::Buf::write_byte);
    buf.def_("read_byte",&vmp::Buf::read_byte);
    buf.def_("write_vector",&vmp::Buf::write_vector);
    buf.def_("read_vector",&vmp::Buf::read_vector);
    buf.def_("write_size",&vmp::Buf::write_size);
    buf.def_("read_size",&vmp::Buf::read_size);
    buf.def_("write_size64",&vmp::Buf::write_size64);
    buf.def_("read_size64",&vmp::Buf::read_size64);  
    buf.def_("write_str",&vmp::Buf::write_str);
    buf.def_("read_str",&vmp::Buf::read_str);
    buf.def_("write_xstr",&vmp::Buf::write_xstr);
    buf.def_("write_xstr_hm",&vmp::Buf::write_xstr_hm);
    buf.def_("read_xstr",&vmp::Buf::read_xstr);
    buf.def_("read_xstr_hm",&vmp::Buf::read_xstr_hm);
    buf.def_("cat",&vmp::Buf::cat);
    buf.def_("cathead",&vmp::Buf::cathead);
    buf.def_("write_buf",&vmp::Buf::write_buf);
    buf.def_("read_buf",&vmp::Buf::read_buf);
    buf.def_("cut",&vmp::Buf::cut);
    buf.def_with_stub("write_file",stub_buf_write_file());
    buf.def_("read_filecreate",&vmp::Buf::read_filecreate);
    buf.def_("read_filewrite",&vmp::Buf::read_filewrite);
    buf.def_("read_fileappend",&vmp::Buf::read_fileappend);
}

