/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 22/01/2023
 */

#include "main.h"

Process::Process(vmp::str id):process::Box(id)
{
    is_root_=false;
    comtype_=process::BOX_PIPE;
    user_="";
    ptype_="";
    module_=0;
    software_="";
}
       
Process::~Process()
{
    rootdir_.clear();
    exports_.clear();
    kill_.clear();
    if(module_ != 0)
        delete module_;
    software_="";
    stdout_.clear();
    stderr_.clear();
}

vmp_index Process::add_stdout(process::StdW *out)
{
    vmp::debug("Required stdw resource '%s' used '%u'",out->name().c_str(),out->refcount());
    stdout_.push_back(out);
    return stdout_.size()-1;
}

void Process::add_pout(process::StdW *box,Process *pin)
{
    vmp_index i=add_stdout(box);
    pout_.insert(i,pin);
    pin->pin_.insert(id(),i);
}

void Process::del_stdout(vmp_index i)
{
    Vampiria *vmp=vmp::Instance::get_global<Vampiria>();
    process::StdW *out=0;
    Process *tmp;
    vmp_index itmp;
    if(i < stdout_.size())
    {
        out=stdout_[i];
        stdout_[i]=0;
        try
        {
            pout_.cancel(i,&tmp);
            tmp->pin_.cancel(id(),&itmp);
            tmp->verify_input();
        }
        catch(vmp::exception &x)
        {
        }
    }
    if(out != 0)
    {
        vmp::str name=out->name();
        vmp_index refcount=vmp->stdwfactory_.close(out);
        vmp::debug("Free stdw resource '%s' used '%d'",name.c_str(),refcount);
    }
}

vmp_index Process::add_stderr(process::StdW *err)
{
    vmp::debug("Required stdw resource '%s' used '%u'",err->name().c_str(),err->refcount());
    stderr_.push_back(err);
    return stderr_.size()-1;
}

void Process::del_stderr(vmp_index i)
{
    Vampiria *vmp=vmp::Instance::get_global<Vampiria>();
    process::StdW *err=0;
    if(i < stderr_.size())
    {
        err=stderr_[i];
        stderr_[i]=0;
    }
    if(err != 0)
    {
        vmp::str name=err->name();
        vmp_index refcount=vmp->stdwfactory_.close(err);
        vmp::debug("Free stdw resource '%s' used '%d'",name.c_str(),refcount);
    }
}

void Process::verify_input()
{
    vmp::vector<vmp::str> kpin=pin_.all_keys();
    if((kpin.size() == 0) && (!is_root_))
        close_input_w();
}

void Process::run()
{
    if(ptype_ == "module")
        module_->run();
    else if(ptype_=="software")
        process::exec(software_,args_,envp_);
    else
        vmp::except("Invalid process type %s",ptype_.c_str());
}

