/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 30/01/2025
 */

#include "config_.h"
#include "vmp.h"
#include "process.h"
#include "xml.h"
#include "modules.h"

#include "process_.h"

#ifndef VAMPIRIA_SOFTWARE_MAIN_H

#define VAMPIRIA_SOFTWARE_MAIN_H 1

typedef enum runmode {UNDEF,CHECK,RUN} RUNMODE;

const vmp::str name_="vampiria";

class Vampiria
{
    private:
       vmp::str root_;
    public:
       Vampiria();
       ~Vampiria();

       vmp::Pid pid_; /*!<Pid main process*/

       RUNMODE mode_;
       vmp::str args_;

       xml::Parser parser_;
       
       vmp::str get_root();
       void destroy();

       vmp::Table<vmp::str,Process *>  process_;/*!<Hash table of objects Process(id,Process)*/
       Process *proot_;
       process::BoxManager *manbox_;
       Process *add_process(xml::Tag *ptag,vmp::str id,vmp_bool init,process::BOX_COM comtype,vmp::str user);
       Process *get_process(vmp::str id);
       void free_process(vmp::str id);

       vmp::args::Envp *envp_;
       modules::ModUtils modules_;

       process::StdWFactory stdwfactory_;
};

void exit_ok();
void exit_failure(vmp::str error);

#endif

#include "opt_.h"
#include "tag/tag_.h"

