/* -*- Mode:Javascript; javscript-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.table lines associated with keys
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 20/03/2025
*/
/**A Component with a title and a body*/
class Mask_Section extends Vmp_Cmp_Div
{
  /**A constructor*/
  constructor()
  {
    super();
    let title=vmp_cmp_div();
    title.style.setProperty("background-color",vmp_rootvar("--background-color-window"));
    title.style.setProperty("border-radius","10px 10px 10px 10px");
    title.style.setProperty("text-align","center");
    this.register_cmp("title",title);
    this.appendChild(title);
  }
  /**
    *Init component
    *@param title {String} Section title
    *@param body {Tag} Body tag
    *@param width {String_css_width} width section
  */
  init(title,body,width)
  {
    this.search_cmp("title").innerHTML= `<h3>${title}</h3>`;
    this.style.setProperty("width",width);
    body.style.setProperty("width","100%");
    vmp_tag_childReplace(this,body,1);
  }
};
try
{
  vmp_wrap_define("mask-section",Mask_Section,'div');
}
catch(error)
{
  vmp_wrap_alert(error);
}
/**
  *Build a component section
  *@param title {String} Section title
  *@param body {Tag} Body tag
  *@param width {String_css_width} width section
*/
function mask_section(title,body,width="100%")
{
  let ret=vmp_wrap_createElement("mask-section",'div');
  ret.init(title,body,width);
  return ret;
}
