/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 15/03/2025
 */
 
#ifndef VAMPIRIA_VMP_LIB_TYPES_H

#define VAMPIRIA_VMP_LIB_TYPES_H 1

namespace vampiria { namespace vmp {

const vmp_uint MAXSIZEREAD=4096;/*<Max byte reading(read or recv system call)*/

//! function Converts str string to int
/*!
    @param istr input string
    @return the converted value(not detect errors)
*/
vmp_int atoi_wrap(vmp::str istr);

//! function Converts str string to real
/*!
    @param istr input string
    @return the converted value(not detect errors)
*/
vmp_real atof_wrap(vmp::str dstr);

//! function Converts str string to int 64 bit
/*!
    @param istr input string
    @return the converted value(not detect errors)
*/
vmp_int64 atoll_wrap(vmp::str dstr);

//! Sets its argument as the seed for a new sequence of pseudo-random integers to be returned by rand_wrap()
/*!
    @param seed seed sequence
*/
void srand_wrap(vmp_uint seed);

//! Function returns a pseudo-random integer in the range 0 to vmp::RANDMAX inclusive(see srand_wrap)
/*!
    @param hop number of jumps
    @return a value between 0 and vmp::RANDMAX
*/
vmp_uint rand_wrap(vmp_uint hop=0);

//! Checks whether the input C number is a Type character.Wrap c function is{type}(int c)
/*!
    @param c input char
    @param type type of data to be checked.("alnum"=alphanumeric,"alpha"=alphabetic,"ascii"=ascii 7 bits unsigned char,"blank"=space
                                            "cntrl"=control,"digit"=0-9,"graph"=printable except space,"lower"=lowercase,
                                            "print"=printable character including space,"punct"=not a space or an alphanumeric,
                                            "space"='\f' '\n' '\r' '\t' '\v',"upper"=uppercase,"xdigit"=0-9 a-f A-F
    @return true if matching char with type,otherwise false
*/
vmp_bool istype_wrap(vmp_int c,vmp::str type);

//! Extract tokens from strings
/*!
    @param str Parsed string.In each subsequent call that should parse the same string, str must be NULL
    @param delim The delim argument specifies a set of bytes that delimit the tokens in the  parsed  string
    @param saveptr Point to the string  to be parsed
    @return a pointer to the next token, or NULL if there are no more tokens
*/
vmp_char *strtok_r_wrap(vmp_char *str, const vmp_char *delim,vmp_char **saveptr);

//! Performs a byte-by-byte comparison of the strings s1 and s2, ignoring the case of the characters
/*!
    @param s1 input string
    @param s2 input string
    @param n  size strings
    @return an integer less than, equal to, or greater than zero if s1 
*/
vmp_int strncasecmp_wrap(const vmp_char *s1, const vmp_char *s2, vmp_size n);

//!Returns a pointer to the first occurrence of the character c in the string s
/*!
    @param s input string
    @param c input char
    @return pointer to char occurrences or null in case of failure
*/
vmp_char *strchr_wrap(const vmp_char *s,vmp_int c);

//!Returns a pointer to the last occurrence of the character c in the string s
/*!
    @param s input string
    @param c input char
    @return pointer to char occurrences or null in case of failure
*/
vmp_char *strrchr_wrap(const vmp_char *s,vmp_int c);

}}

#endif

