/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 01/02/2024
 */

#include "vmp.h"

namespace vampiria { namespace vmp {

void except_s(vmp::str msg)
{
    vmp::exception_default except(msg);
    throw except;
}

void except(const vmp_char *fmt,...)
{
    vmp::str msg;
    va_list ap;
    va_start(ap,fmt);
    msg=vmp::va_wrap(fmt,ap);
    va_end(ap);
    except_s(msg);
}

void except_args_s(vmp::str msg)
{
    throw vmp::invalid_argument(msg);
}

void except_args(const vmp_char *fmt,...)
{
    vmp::str msg;
    va_list ap;
    va_start(ap,fmt);
    msg=vmp::va_wrap(fmt,ap);
    va_end(ap);
    except_args_s(msg);
}

void except_alloc()
{
    throw vmp::bad_alloc();
}

vmp_int get_errno()
{
    return errno;
}

vmp::str value_errno()
{
    return vmp::strerror_wrap(errno);
}

void except_errno()
{
    except_s(vmp::strerror_wrap(errno));
}

vmp::str value_errno_set(vmp_int err)
{
    errno=err;
    return value_errno();
}

void except_errno_set(vmp_int err)
{
    errno=err;
    except_errno();
}

void except_runtime(vmp::str err)
{
    throw vmp::runtime_error(err);
}

void except_check_pointer(void *pointer,vmp::str error)
{
    if(pointer == 0)
       vmp::except_s(error);
}

}}

