/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 30/05/2024
 */

#ifndef VAMPIRIA_PYLIB_CONVERTER_H

#define VAMPIRIA_PYLIB_CONVERTER_H 1

namespace vampiria { namespace pylib {

template<typename T>
pylib::Objref *Converter(T value,vmp_bool retfree)
{
    if(pylib::is_vector<T>::value_)
    {
       return pylib::is_vector<T>::Converter(value,retfree);
    }
    pylib::type_info t;
    if (pylib::is_pointer<T>::value_)
        t = pylib::unwrap_type_id((T) 0);
    else
        t = pylib::unwrap_type_id((T*)0);
    pylib::Objtype *obj=Registry::pytypeobj(t);
    if(is_pointer<T>::is_null(value))
        return retnone();
    pylib::Objref *ret=pylib::make_instance(obj);
    pylib::set_instance(ret,value,retfree);
    return ret;
}

template<>
pylib::Objref *Converter<vmp_char>(vmp_char value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_char *>(vmp_char *value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_uchar>(vmp_uchar value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_uchar *>(vmp_uchar *value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_int16>(vmp_int16 value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_int16 *>(vmp_int16 *value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_uint16>(vmp_uint16 value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_uint16 *>(vmp_uint16 *value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_int>(vmp_int value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_int *>(vmp_int *value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_uint>(vmp_uint value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_uint *>(vmp_uint *value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_int64>(vmp_int64 value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_int64 *>(vmp_int64 *value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_uint64>(vmp_uint64 value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_uint64 *>(vmp_uint64 *value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_real>(vmp_real value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_real *>(vmp_real *value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_bool>(vmp_bool value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_bool *>(vmp_bool *value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp::str>(vmp::str value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp::str *>(vmp::str *value,vmp_bool retfree);

template<>
pylib::Objref *Converter<pylib::Objref *>(pylib::Objref *value,vmp_bool retfree);

//!Convert a table to python dictionary
/*!
     @param table input table
     @return new pyobject dictionary or except in case of failure
*/
template<typename KEY,typename DATA>
pylib::Objref *Converter_table(vmp::Table<KEY,DATA> *table)
{
   pylib::Objref *ret=0,*key=0,*val=0;
   DATA value;
   vmp::except_check_pointer((void *) table,"Converter_table null pointer input table");
   try
   {
       ret=pydict_new();
       vmp::vector<KEY> keys=table->all_keys();
       for(vmp_index i=0;i<keys.size();i++)
       {
           key=pylib::Converter<KEY>(keys[i]);
           table->search(keys[i],&value);
           val=pylib::Converter<DATA>(value);
           pylib::pydict_setitem(ret,key,val);
           key=0;
           val=0;
       }
           
   }
   catch(vmp::exception &x)
   {
       if(ret != 0)
           pylib::pydict_clear(ret);
       if(key != 0)
           pylib::decref(key);
       if(val != 0)
           pylib::decref(val);
       vmp::except("Converter_table error '%s'",x.what());    
   }
   return ret; 
}

}}

#endif
