/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 13/09/2024
 */

#include "packet.h"

namespace vampiria { namespace packet { namespace websocket {

FramingExt::FramingExt(vmp::str name)
{
    name_=name;
}

FramingExt::~FramingExt()
{
    name_="";
}

FramingExtData::FramingExtData()
{
    ext_=0;
    data_=0;
}

FramingExtData::~FramingExtData()
{
    reset();    
}

void FramingExtData::reset()
{
    ext_=0;
    accepted_="";
    data_=0;
}

FramingExtManager::FramingExtManager()
{
}

FramingExtManager::~FramingExtManager()
{
    vmp::vector_delete_alldata<packet::websocket::FramingExt *>(&exts_);
}

void FramingExtManager::add_ext(packet::websocket::FramingExt *ext)
{
    if(ext != 0)
    {
        vmp_index i;
        for(i=0;i<exts_.size();i++)
        {
            if(exts_[i]->name_ == ext->name_)
                vmp::except("packet::web::FramingExtManager::add_ext(ext->name_='%s') duplicate value",ext->name_.c_str());
            exts_.push_back(ext);
        }
    }
}

packet::websocket::FramingExt *FramingExtManager::search(vmp::str name)
{
    for(vmp_index i=0;i<exts_.size();i++)
        if(exts_[i]->name_ == name)
            return exts_[i];
    return 0;  
}

vmp::str FramingExtManager::message_client()
{
    vmp::str ret="";
    for(vmp_index i=0;i<exts_.size();i++)
    {
        if(i == 0)
            vmp::unicode::str_cwrite(&ret,"%s",exts_[i]->message_client().c_str());
        else
            vmp::unicode::str_cwrite(&ret,", %s",exts_[i]->message_client().c_str());
    }
    return ret;
}

}}}

