/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 17/11/2020
 */

#include "packet.h"

namespace vampiria { namespace packet {

Ethernet_P::Ethernet_P():packet::Packet(packet::P_ETHERNET)
{
    try
    {
        // data_[0]
        packet::DataMac *dst=new packet::DataMac("dstmac");
        insert_data(dst);

        // data_[1]
        packet::DataMac *src=new packet::DataMac("srcmac");
        insert_data(src);
        
        // data_[2]
        packet::DataEtherType *type=new packet::DataEtherType("ethertype");
        insert_data(type);
    }
    catch(vmp::exception &x)
    {
        vmp::except_s("packet::Ethernet_P::Ethernet_p() internal bugs");
    }
}
        
Ethernet_P::~Ethernet_P()
{
}

vmp::str Ethernet_P::next_type()
{
    return get("ethertype");
}

}}

