/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 30/05/2024
 */

#ifndef VAMPIRIA_PACKET_BUFFER_H

#define VAMPIRIA_PACKET_BUFFER_H 1

namespace vampiria { namespace packet {

//! DataType Buffer
class DataBuffer:public packet::DataBytes
{
    private:
        vmp::Buf buf_;/*!< data buffer*/
        vmp_size setsize_;/*!< size setting*/
    public:
        //! A constructor
        /*!
            @param field data field
            @param setsize buffer size.if setsize = 0 the buffer size is variable 
                        and if the default read is used it reads all the data
                        remaining from the input buffer.
        */
        DataBuffer(vmp::str field,vmp_size setsize=0);

        //! A destructor
        ~DataBuffer();

        //! Virtual function
        vmp::str get(vmp::str field);

        //! Virtual function
        void set(vmp::str field,vmp::str data);

        //! Virtual function
        void read(vmp::Buf *buf);

        //! Virtual function
        void write(vmp::Buf *buf);

        //! Virtual function
        vmp::str print();

        //! Return raw data
        /*!
            @return Buffer
            @sa buf_
        */
        vmp::Buf *get_data();

        //! Read size bytes from the buffer. if setsize_! = 0 brings the size of the data to setsize_
        /*!
            @param buf input buf
            @param size bytes read
        */
        void read_size_data(vmp::Buf *buf,vmp_size size);
        
        //! Change date datalen and reset buffer
        /*!
             @param datalen new datalen
             @return void or except in case of failure
        */
        void set_new_size(vmp_size size);
};

}}

#endif

