/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 10/04/2022
 */

#ifndef VAMPIRIA_NET_DNS_H

#define VAMPIRIA_NET_DNS_H 1

namespace vampiria { namespace net {

//! Sends a type A dns request in tcp and returns the list of ipv4 associated with the host
/*!
    @param host request host
    @param dnsip ip of the dns server to use
    @param dnsport port of the dns server to use
    @param timeout socket timeout > 0.0
    @return list of ipv4 associated with the host or empty list in case of failure
*/
vmp::vector<vmp::str> tcp_resolve4(vmp::str host,vmp::str dnsip,vmp::str dnsport,vmp::time::Time timeout);

//! Sends a type AAAA dns request in tcp and returns the list of ipv6 associated with the host
/*!
    @param host request host
    @param dnsip ip of the dns server to use
    @param dnsport port of the dns server to use
    @param timeout socket timeout > 0.0
    @return list of ipv6 associated with the host or empty list in case of failure
*/
vmp::vector<vmp::str> tcp_resolve6(vmp::str host,vmp::str dnsip,vmp::str dnsport,vmp::time::Time timeout);

//! Sends a type MX dns request in tcp and returns the list of mail exchange associated with the host
/*!
    @param host request host
    @param dnsip ip of the dns server to use
    @param dnsport port of the dns server to use
    @param timeout socket timeout > 0.0
    @return list of mail exchange associated with the host or empty list in case of failure
*/
vmp::vector<vmp::str> tcp_resolveMX(vmp::str host,vmp::str dnsip,vmp::str dnsport,vmp::time::Time timeout);

}}

#endif

